#pragma once

#include <yandex/maps/wiki/configs/editor/magic_strings.h>

#include <string>

namespace maps {
namespace wiki {


/*****************************************************************************/
/*                            A T T R I B U T E S                            */
/*****************************************************************************/
const std::string ATTR_ACCESS_ID_SUFFIX = ":access_id";
const std::string ATTR_AD_CAPITAL = "ad:capital";
const std::string ATTR_AD_DISP_CLASS = "ad:disp_class";
const std::string ATTR_AD_FC_IS_INTERIOR = "ad_fc:is_interior";
const std::string ATTR_AD_NEUTRAL_FC_IS_INTERIOR = "ad_neutral_fc:is_interior";
const std::string ATTR_AD_ISOCODE = "ad:isocode";
const std::string ATTR_AD_LEVEL_KIND = "ad:level_kind";
const std::string ATTR_AD_POPULATION = "ad:population";
const std::string ATTR_AD_SUBST_FC_IS_EXCLUDED = "ad_subst_fc:is_excluded";
const std::string ATTR_AD_SUBST_LEVEL_KIND = "ad_subst:level_kind";
const std::string ATTR_AD_TOWN = "ad:town";
const std::string ATTR_ADDR_UNITY_NAME = "addr_unity:name";
const std::string ATTR_AOI_NAME = "aoi:name";
const std::string ATTR_AOI_TYPE = "aoi:type";
const std::string ATTR_ARRIVAL_POINT_IS_MAJOR = "arrival_point:is_major";
const std::string ATTR_COND_CAM_COND_TYPE = "cond_cam:cond_type";
const std::string ATTR_COND_ACCESS_ID = "cond:access_id";
const std::string ATTR_COND_COND_TYPE = "cond:cond_type";
const std::string ATTR_COND_COND_DT = "cond:cond_dt";
const std::string ATTR_COND_ANNOTATION_ANNOTATION_ID = "cond_annotation:annotation_id";
const std::string ATTR_COND_ANNOTATION_PHRASE_NAME = "cond_annotation_phrase:name";
const std::string ATTR_COND_ANNOTATION_PHRASE_ELEMENT = "cond_annotation_phrase:cond_annotation_phrase_element";
const std::string ATTR_COND_ANNOTATION_PHRASE_ELEMENT_NAME = "cond_annotation_phrase_element:name";
const std::string ATTR_COND_ANNOTATION_PHRASE_ELEMENT_LANG = "cond_annotation_phrase_element:lang";
const std::string ATTR_COND_DS_DIRECTION = "cond_ds:direction";
const std::string ATTR_COND_DS_COND_DS_EL = "cond_ds:cond_ds_el";
const std::string ATTR_COND_DS_EL_ICON = "cond_ds_el:icon";
const std::string ATTR_COND_DS_EL_NAME = "cond_ds_el:name";
const std::string ATTR_COND_DS_EL_TYPE = "cond_ds_el:type";
const std::string ATTR_COND_DS_EL_ORDER = "cond_ds_el:order";
const std::string ATTR_COND_LANE_LANE = "cond_lane:lane";
const std::string ATTR_COND_LANE_LANE_MAX = "cond_lane:lane_max";
const std::string ATTR_COND_LANE_LANE_MIN = "cond_lane:lane_min";
const std::string ATTR_FEED_REGION_NAME = "feed_region:name";
const std::string ATTR_FLAT_RANGE_FLATS = "flat_range:flats";
const std::string ATTR_FLAT_RANGE_FLAT_FIRST = "flat_range:flat_first";
const std::string ATTR_FLAT_RANGE_FLAT_LAST = "flat_range:flat_last";
const std::string ATTR_HYDRO_FC_IS_INTERIOR = "hydro_fc:is_interior";
const std::string ATTR_HYDRO_FT_TYPE_ID = "hydro:ft_type_id";
const std::string ATTR_HYDRO_LN_FT_TYPE_ID = "hydro_ln:ft_type_id";
const std::string ATTR_INDOOR_RADIOMAP_CAPTURER_PATH_DESCRIPTION = "indoor_radiomap_capturer_path:description";
const std::string ATTR_MRC_REGION_NAME = "mrc_region:name";
const std::string ATTR_MRC_REGION_TYPE = "mrc_region:type";
const std::string ATTR_MRC_POINT_NAME = "mrc_point:name";
const std::string ATTR_MRC_PEDESTRIAN_REGION_NAME = "mrc_pedestrian_region:name";
const std::string ATTR_OUTSOURCE_REGION_COMPANY_ID = "outsource_region:company_id";
const std::string ATTR_OUTSOURCE_REGION_OUTSOURCER_LOGIN = "outsource_region:outsourcer_login";
const std::string ATTR_PEDESTRIAN_REGION_TASK_ID = "pedestrian_region:task_id";
const std::string ATTR_PEDESTRIAN_REGION_TASK_TYPE = "pedestrian_region:task_type";
const std::string ATTR_POI_BUSINESS_ID = "poi:business_id";
const std::string ATTR_POI_BUSINESS_RUBRIC_ID = "poi:business_rubric_id";
const std::string ATTR_POI_ENTRANCE_TYPE = "poi_entrance:type";
const std::string ATTR_POI_IS_GEOPRODUCT = "poi:is_geoproduct";
const std::string ATTR_POI_POSITION_QUALITY = "poi:position_quality";
const std::string ATTR_INDOOR_POI_POSITION_QUALITY = "indoor_poi:position_quality";
const std::string ATTR_RD_EL_DR = "rd_el:dr";
const std::string ATTR_RD_EL_F_LANE = "rd_el:f_lane";
const std::string ATTR_RD_EL_F_ZLEV = "rd_el:f_zlev";
const std::string ATTR_RD_EL_FC = "rd_el:fc";
const std::string ATTR_RD_EL_FOW = "rd_el:fow";
const std::string ATTR_RD_EL_PAVED = "rd_el:paved";
const std::string ATTR_RD_EL_SPEED_CAT = "rd_el:speed_cat";
const std::string ATTR_RD_EL_SPEED_LIMIT = "rd_el:speed_limit";
const std::string ATTR_RD_EL_SPEED_LIMIT_T = "rd_el:speed_limit_t";
const std::string ATTR_RD_EL_SPEED_LIMIT_TRUCK = "rd_el:speed_limit_truck";
const std::string ATTR_RD_EL_SPEED_LIMIT_TRUCK_T = "rd_el:speed_limit_truck_t";
const std::string ATTR_RD_EL_STRUCT_TYPE = "rd_el:struct_type";
const std::string ATTR_RD_EL_T_LANE = "rd_el:t_lane";
const std::string ATTR_RD_EL_T_ZLEV = "rd_el:t_zlev";
const std::string ATTR_RD_EL_TOLL = "rd_el:toll";
const std::string ATTR_RD_RD_TYPE = "rd:rd_type";
const std::string ATTR_REL_MASTER = "rel:master";
const std::string ATTR_REL_ROLE = "rel:role";
const std::string ATTR_REL_SEQ_NUM = "rel:seq_num";
const std::string ATTR_REL_SLAVE = "rel:slave";
const std::string ATTR_ROAD_MARKING_POLYGONAL_TYPE = "road_marking_polygonal:type";
const std::string ATTR_ROAD_MARKING_LINEAR_TYPE = "road_marking_linear:type";
const std::string ATTR_ROAD_MARKING_YAW = "road_marking:yaw";
const std::string ATTR_ROAD_MARKING_POINT_LANE_DIRECTION_TYPE = "road_marking_point_lane_direction:type";
const std::string ATTR_ROAD_MARKING_POINT_SYMBOL_TYPE = "road_marking_point_symbol:type";
const std::string ATTR_ROAD_MARKING_POINT_ROAD_SIGN_TYPE = "road_marking_point_road_sign:type";
const std::string ATTR_ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT_VALUE = "road_marking_point_road_sign_speed_limit:value";
const std::string ATTR_ROAD_MARKING_POINT_TEXT_TEXT = "road_marking_point_text:text";
const std::string ATTR_ROAD_SURFACE_F_ZLEV = "road_surface:f_zlev";
const std::string ATTR_ROAD_SURFACE_T_ZLEV = "road_surface:t_zlev";
const std::string ATTR_ROAD_SURFACE_TYPE = "road_surface:type";
const std::string ATTR_SPORT_TRACK_FT_TYPE_ID = "sport_track:ft_type_id";
const std::string ATTR_SYS_BLOCKED = "sys:blocked";
const std::string ATTR_SYS_IGNORE_FORBIDDEN_OVERLAY = "sys:ignore_forbidden_overlay";
const std::string ATTR_SYS_IMPORT_SOURCE = "sys:import_source";
const std::string ATTR_SYS_IMPORT_SOURCE_ID = "sys:import_source_id";
const std::string ATTR_TRANSPORT_METRO_LINE_FT_TYPE_ID = "transport_metro_line:ft_type_id";
const std::string ATTR_TRANSPORT_STOP_WAYPOINT = "transport_stop:waypoint";
const std::string ATTR_TRANSPORT_THREAD_STOP_NO_DISEMBARKATION = "transport_thread_stop:no_disembarkation";
const std::string ATTR_TRANSPORT_THREAD_STOP_NO_EMBARKATION = "transport_thread_stop:no_embarkation";
const std::string ATTR_TRANSPORT_TRANSITION_BOARDING_ONEWAY = "transport_transition_boarding:oneway";
const std::string ATTR_TRANSPORT_BOARDING_OPTIONS = "transport:boarding_options";
const std::string ATTR_DISP_CLASS_SUFFIX = ":disp_class";
const std::string ATTR_VEHICLE_RESTRICTION_UNIVERSAL_ID = "vehicle_restriction:universal_id";
const std::string ATTR_RD_EL_VEHICLE_RESTRICTION_UNIVERSAL_IDS = "rd_el:vehicle_restriction_universal_ids";
const std::string ATTR_UID_SUFFIX = "_uid";
const std::string ATTR_VEHICLE_RESTRICTION_WEIGHT_LIMIT ="vehicle_restriction:weight_limit";
const std::string ATTR_VEHICLE_RESTRICTION_AXLE_WEIGHT_LIMIT ="vehicle_restriction:axle_weight_limit";
const std::string ATTR_VEHICLE_RESTRICTION_MAX_WEIGHT_LIMIT ="vehicle_restriction:max_weight_limit";
const std::string ATTR_VEHICLE_RESTRICTION_HEIGHT_LIMIT ="vehicle_restriction:height_limit";
const std::string ATTR_VEHICLE_RESTRICTION_WIDTH_LIMIT ="vehicle_restriction:width_limit";
const std::string ATTR_VEHICLE_RESTRICTION_LENGTH_LIMIT ="vehicle_restriction:length_limit";
const std::string ATTR_VEHICLE_RESTRICTION_PAYLOAD_LIMIT ="vehicle_restriction:payload_limit";
const std::string ATTR_VEHICLE_RESTRICTION_MIN_ECO_CLASS ="vehicle_restriction:min_eco_class";
const std::string ATTR_VEHICLE_RESTRICTION_TRAILER_NOT_ALLOWED ="vehicle_restriction:trailer_not_allowed";


/*****************************************************************************/
/*                     A T T R I B U T E S   V A L U E S                     */
/*****************************************************************************/
const std::string AD_LEVEL_KIND_1_COUNTRY = "1";
const std::string AD_LEVEL_KIND_2_STATE = "2";
const std::string AD_LEVEL_KIND_4_LOCALITY = "4";
const std::string ATTR_VALUE_DISP_CLASS_IGNORE = "10";

const std::string RD_EL_FOW_NOT_SET = "0";

const std::string COND_TYPE_BARRIER = "5";


/*****************************************************************************/
/*                            C A T E G O R I E S                            */
/*****************************************************************************/
const std::string CATEGORY_AD = "ad";
const std::string CATEGORY_ADDR = "addr";
const std::string CATEGORY_ADDR_UNITY = "addr_unity";
const std::string CATEGORY_AD_CNT = "ad_cnt";
const std::string CATEGORY_AD_EL = "ad_el";
const std::string CATEGORY_AD_FC = "ad_fc";
const std::string CATEGORY_AD_JC = "ad_jc";
const std::string CATEGORY_AD_SUBST = "ad_subst";
const std::string CATEGORY_AD_SUBST_FC = "ad_subst_fc";
const std::string CATEGORY_AOI = "aoi";
const std::string CATEGORY_ARRIVAL_POINT = "arrival_point";
const std::string CATEGORY_BLD = "bld";
const std::string CATEGORY_BOUND_JC = "bound_jc";
const std::string CATEGORY_COND = "cond";
const std::string CATEGORY_COND_ANNOTATION = "cond_annotation";
const std::string CATEGORY_COND_ANNOTATION_PHRASE = "cond_annotation_phrase";
const std::string CATEGORY_COND_BORDER_CHECKPOINT = "cond_border_checkpoint";
const std::string CATEGORY_COND_CAM = "cond_cam";
const std::string CATEGORY_COND_CLOSURE = "cond_closure";
const std::string CATEGORY_COND_DS = "cond_ds";
const std::string CATEGORY_COND_LANE = "cond_lane";
const std::string CATEGORY_COND_RAILWAY_CROSSING = "cond_railway_crossing";
const std::string CATEGORY_COND_SPEED_BUMP = "cond_speed_bump";
const std::string CATEGORY_COND_TRAFFIC_LIGHT = "cond_traffic_light";
const std::string CATEGORY_COND_TOLL = "cond_toll";
const std::string CATEGORY_DIFFALERT_REGION = "diffalert_region";
const std::string CATEGORY_ENTRANCE = "poi_entrance";
const std::string CATEGORY_FEED_REGION = "feed_region";
const std::string CATEGORY_HYDRO = "hydro";
const std::string CATEGORY_HYDRO_FC = "hydro_fc";
const std::string CATEGORY_HYDRO_FC_EL = "hydro_fc_el";
const std::string CATEGORY_HYDRO_FC_JC = "hydro_fc_jc";
const std::string CATEGORY_HYDRO_LN = "hydro_ln";
const std::string CATEGORY_HYDRO_LN_EL = "hydro_ln_el";
const std::string CATEGORY_HYDRO_LN_JC = "hydro_ln_jc";
const std::string CATEGORY_HYDRO_POINT = "hydro_point";
const std::string CATEGORY_MERGE_REGION = "merge_region";
const std::string CATEGORY_IMAGE_OVERLAY = "image_overlay";
const std::string CATEGORY_IMAGE_OVERLAY_PUBLIC = "image_overlay_public";
const std::string CATEGORY_INDOOR_AREA = "indoor_area";
const std::string CATEGORY_INDOOR_BARRIER = "indoor_barrier";
const std::string CATEGORY_INDOOR_LEVEL = "indoor_level";
const std::string CATEGORY_INDOOR_RADIOMAP_CAPTURER_PATH = "indoor_radiomap_capturer_path";
const std::string CATEGORY_INDOOR_PLAN = "indoor_plan";
const std::string CATEGORY_INDOOR_POI_AUTO = "indoor_poi_auto";
const std::string CATEGORY_INDOOR_POI_EDU = "indoor_poi_edu";
const std::string CATEGORY_INDOOR_POI_FINANCE = "indoor_poi_finance";
const std::string CATEGORY_INDOOR_POI_FOOD = "indoor_poi_food";
const std::string CATEGORY_INDOOR_POI_GOVERMENT = "indoor_poi_goverment";
const std::string CATEGORY_INDOOR_POI_INFO = "indoor_poi_info";
const std::string CATEGORY_INDOOR_POI_INFRA = "indoor_poi_infra";
const std::string CATEGORY_INDOOR_POI_LEISURE = "indoor_poi_leisure";
const std::string CATEGORY_INDOOR_POI_MEDICINE = "indoor_poi_medicine";
const std::string CATEGORY_INDOOR_POI_SERVICE = "indoor_poi_service";
const std::string CATEGORY_INDOOR_POI_SPORT = "indoor_poi_sport";
const std::string CATEGORY_INDOOR_POI_SHOPPING = "indoor_poi_shopping";
const std::string CATEGORY_INDOOR_POI_RELIGION = "indoor_poi_religion";

const std::string CATEGORY_POI_MEDICINE = "poi_medicine";
const std::string CATEGORY_POI_EDU = "poi_edu";
const std::string CATEGORY_POI_FINANCE = "poi_finance";
const std::string CATEGORY_POI_SHOPPING = "poi_shopping";
const std::string CATEGORY_POI_GOVERMENT = "poi_goverment";
const std::string CATEGORY_POI_RELIGION = "poi_religion";
const std::string CATEGORY_POI_FOOD = "poi_food";
const std::string CATEGORY_POI_AUTO = "poi_auto";
const std::string CATEGORY_POI_SPORT = "poi_sport";
const std::string CATEGORY_POI_LEISURE = "poi_leisure";
const std::string CATEGORY_POI_URBAN = "poi_urban";
const std::string CATEGORY_POI_SERVICE = "poi_service";

const std::string CATEGORY_MODEL3D = "model3d";
const std::string CATEGORY_MRC_POINT = "mrc_point";
const std::string CATEGORY_MRC_REGION = "mrc_region";
const std::string CATEGORY_MRC_PEDESTRIAN_REGION = "mrc_pedestrian_region";
const std::string CATEGORY_OUTSOURCE_REGION = "outsource_region";
const std::string CATEGORY_PEDESTRIAN_REGION = "pedestrian_region";
const std::string CATEGORY_RD = "rd";
const std::string CATEGORY_RD_EL = "rd_el";
const std::string CATEGORY_RD_JC = "rd_jc";
const std::string CATEGORY_REGION = "region";
const std::string CATEGORY_AD_NEUTRAL = "ad_neutral";
const std::string CATEGORY_AD_NEUTRAL_FC = "ad_neutral_fc";
const std::string CATEGORY_AD_NEUTRAL_EL = "ad_neutral_el";
const std::string CATEGORY_AD_NEUTRAL_JC = "ad_neutral_jc";
const std::string CATEGORY_RELIEF = "relief";
const std::string CATEGORY_RELIEF_EL = "relief_el";
const std::string CATEGORY_RELIEF_FC = "relief_fc";
const std::string CATEGORY_RELIEF_JC = "relief_jc";
const std::string CATEGORY_RELIEF_POINT = "relief_point";
const std::string CATEGORY_SPORT_TRACK = "sport_track";
const std::string CATEGORY_TRANSPORT_AIRPORT = "transport_airport";
const std::string CATEGORY_TRANSPORT_AIRPORT_TERMINAL = "transport_airport_terminal";
const std::string CATEGORY_TRANSPORT_BUS_ROUTE = "transport_bus_route";
const std::string CATEGORY_TRANSPORT_BUS_THREAD = "transport_bus_thread";
const std::string CATEGORY_TRANSPORT_BUS_THREAD_CONNECTOR = "transport_bus_thread_connector";
const std::string CATEGORY_TRANSPORT_HELICOPTER = "transport_helicopter";
const std::string CATEGORY_TRANSPORT_METRO_EL = "transport_metro_el";
const std::string CATEGORY_TRANSPORT_METRO_EXIT = "transport_metro_exit";
const std::string CATEGORY_TRANSPORT_METRO_JC = "transport_metro_jc";
const std::string CATEGORY_TRANSPORT_METRO_LINE = "transport_metro_line";
const std::string CATEGORY_TRANSPORT_METRO_OPERATOR = "transport_metro_operator";
const std::string CATEGORY_TRANSPORT_METRO_STATION = "transport_metro_station";
const std::string CATEGORY_TRANSPORT_METRO_THREAD = "transport_metro_thread";
const std::string CATEGORY_TRANSPORT_METRO_THREAD_CONNECTOR = "transport_metro_thread_connector";
const std::string CATEGORY_TRANSPORT_OPERATOR = "transport_operator";
const std::string CATEGORY_TRANSPORT_PASSAGEWAY = "transport_passageway";
const std::string CATEGORY_TRANSPORT_PASSAGEWAY_BOARDING = "transport_passageway_boarding";
const std::string CATEGORY_TRANSPORT_RAILWAY = "transport_railway";
const std::string CATEGORY_TRANSPORT_RAILWAY_EL = "transport_railway_el";
const std::string CATEGORY_TRANSPORT_RAILWAY_JC = "transport_railway_jc";
const std::string CATEGORY_TRANSPORT_RAILWAY_PLATFORM = "transport_railway_platform";
const std::string CATEGORY_TRANSPORT_RAILWAY_STATION = "transport_railway_station";
const std::string CATEGORY_TRANSPORT_STOP = "transport_stop";
const std::string CATEGORY_TRANSPORT_TERMINAL = "transport_terminal";
const std::string CATEGORY_TRANSPORT_THREAD_STOP = "transport_thread_stop";
const std::string CATEGORY_TRANSPORT_TRAM_EL = "transport_tram_el";
const std::string CATEGORY_TRANSPORT_TRAM_JC = "transport_tram_jc";
const std::string CATEGORY_TRANSPORT_TRAM_ROUTE = "transport_tram_route";
const std::string CATEGORY_TRANSPORT_TRAM_THREAD = "transport_tram_thread";
const std::string CATEGORY_TRANSPORT_TRAM_THREAD_CONNECTOR = "transport_tram_thread_connector";
const std::string CATEGORY_TRANSPORT_TRANSITION = "transport_transition";
const std::string CATEGORY_TRANSPORT_TRANSITION_BOARDING = "transport_transition_boarding";
const std::string CATEGORY_TRANSPORT_WATERWAY_EL = "transport_waterway_el";
const std::string CATEGORY_TRANSPORT_WATERWAY_JC = "transport_waterway_jc";
const std::string CATEGORY_TRANSPORT_WATERWAY_ROUTE = "transport_waterway_route";
const std::string CATEGORY_TRANSPORT_WATERWAY_STOP = "transport_waterway_stop";
const std::string CATEGORY_TRANSPORT_WATERWAY_THREAD = "transport_waterway_thread";
const std::string CATEGORY_TRANSPORT_WATERWAY_THREAD_CONNECTOR = "transport_waterway_thread_connector";


const std::string CATEGORY_URBAN = "urban";
const std::string CATEGORY_URBAN_AREAL = "urban_areal";
const std::string CATEGORY_URBAN_EL = "urban_el";
const std::string CATEGORY_URBAN_FC = "urban_fc";
const std::string CATEGORY_URBAN_JC = "urban_jc";
const std::string CATEGORY_URBAN_ROADNET = "urban_roadnet";
const std::string CATEGORY_URBAN_ROADNET_AREAL = "urban_roadnet_areal";
const std::string CATEGORY_URBAN_ROADNET_EL = "urban_roadnet_el";
const std::string CATEGORY_URBAN_ROADNET_FC = "urban_roadnet_fc";
const std::string CATEGORY_URBAN_ROADNET_FENCE_EL = "urban_roadnet_fence_el";
const std::string CATEGORY_URBAN_ROADNET_FENCE_JC = "urban_roadnet_fence_jc";
const std::string CATEGORY_URBAN_ROADNET_JC = "urban_roadnet_jc";
const std::string CATEGORY_URBAN_ROADNET_PARKING_CONTROLLED_ZONE = "urban_roadnet_parking_controlled_zone";
const std::string CATEGORY_URBAN_ROADNET_PARKING_LOT = "urban_roadnet_parking_lot";
const std::string CATEGORY_URBAN_ROADNET_PARKING_LOT_LINEAR = "urban_roadnet_parking_lot_linear";
const std::string CATEGORY_VEGETATION = "vegetation";
const std::string CATEGORY_VEGETATION_EL = "vegetation_el";
const std::string CATEGORY_VEGETATION_FC = "vegetation_fc";
const std::string CATEGORY_VEGETATION_JC = "vegetation_jc";
const std::string CATEGORY_VEGETATION_CNT = "vegetation_cnt";
const std::string CATEGORY_VEHICLE_RESTRICTION = "vehicle_restriction"s;
const std::string CATEGORY_ZIPCODE = "zipcode";

const std::string CATEGORY_ROAD_SURFACE = "road_surface";
const std::string CATEGORY_ROAD_MARKING_POLYGONAL = "road_marking_polygonal";
const std::string CATEGORY_ROAD_MARKING_LINEAR = "road_marking_linear";
const std::string CATEGORY_ROAD_MARKING_POINT_LANE_DIRECTION = "road_marking_point_lane_direction";
const std::string CATEGORY_ROAD_MARKING_POINT_SYMBOL = "road_marking_point_symbol";
const std::string CATEGORY_ROAD_MARKING_POINT_ROAD_SIGN = "road_marking_point_road_sign";
const std::string CATEGORY_ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT = "road_marking_point_road_sign_speed_limit";
const std::string CATEGORY_ROAD_MARKING_POINT_TEXT = "road_marking_point_text";

/*****************************************************************************/
/*                       C A T E G O R Y   G R O U P S                       */
/*****************************************************************************/
const std::string CATEGORY_GROUP_COMMON  = "common"; ///< A fake category group for changes upon several objects possibly from different category groups.

const std::string CATEGORY_GROUP_ADDR = "addr_group";
const std::string CATEGORY_GROUP_BLD = "bld_group";
const std::string CATEGORY_GROUP_COND = "cond_group";
const std::string CATEGORY_GROUP_ENTRANCE = "entrance_group";
const std::string CATEGORY_GROUP_FENCE = "fence_group";
const std::string CATEGORY_GROUP_INDOOR = "indoor_group";
const std::string CATEGORY_GROUP_PARKING = "parking_group";
const std::string CATEGORY_GROUP_POI = "poi_group";
const std::string CATEGORY_GROUP_RD = "rd_group";
const std::string CATEGORY_GROUP_SERVICE = "service_group";
const std::string CATEGORY_GROUP_TRANSPORT = "transport_group";
const std::string CATEGORY_GROUP_TRANSPORT_AIRPORT = "transport_airport_group";
const std::string CATEGORY_GROUP_TRANSPORT_METRO = "transport_metro_group";
const std::string CATEGORY_GROUP_TRANSPORT_RAILWAY = "transport_railway_group";
const std::string CATEGORY_GROUP_TRANSPORT_WATERWAY = "transport_waterway_group";
const std::string CATEGORY_GROUP_HD_MAP = "hd_map_group";


/*****************************************************************************/
/*                                 N A M E S                                 */
/*****************************************************************************/
const std::string AD_NM = "ad_nm";
const std::string COND_CLOSURE_NM = "cond_closure_nm";
const std::string HYDRO_NM = "hydro_nm";
const std::string RD_NM = "rd_nm";
const std::string RELIEF_NM = "relief_nm";
const std::string SPORT_TRACK_NM = "sport_track_nm";
const std::string TRANSPORT_AIRPORT_NM = "transport_airport_nm";
const std::string TRANSPORT_METRO_NM = "transport_metro_nm";
const std::string TRANSPORT_NM = "transport_nm";
const std::string TRANSPORT_WATERWAY_NM = "transport_waterway_nm";
const std::string URBAN_NM = "urban_nm";
const std::string URBAN_ROADNET_NM = "urban_roadnet_nm";
const std::string VEGETATION_NM = "vegetation_nm";


/*****************************************************************************/
/*                                 R O L E S                                 */
/*****************************************************************************/
const std::string ROLE_ADDR_ASSOCIATED_WITH = "addr_associated_with";
const std::string ROLE_ADDR_ASSOCIATED_WITH_ZIPCODE = "addr_associated_with_zipcode";
const std::string ROLE_ANNOTATING = "annotating";
const std::string ROLE_ASSIGNED = "assigned";
const std::string ROLE_ASSIGNED_AD_NEUTRAL = "assigned_ad_neutral";
const std::string ROLE_ASSIGNED_INDOOR_AREA = "assigned_indoor_area";
const std::string ROLE_ASSIGNED_INDOOR_BARRIER = "assigned_indoor_barrier";
const std::string ROLE_ASSIGNED_INDOOR_RADIOMAP_CAPTURER_PATH = "assigned_indoor_radiomap_capturer_path";
const std::string ROLE_ASSIGNED_BUS = "assigned_bus";
const std::string ROLE_ASSIGNED_METRO = "assigned_metro";
const std::string ROLE_ASSIGNED_ROAD_MARKING_LINEAR = "assigned_road_marking_linear";
const std::string ROLE_ASSIGNED_ROAD_MARKING_POLYGONAL = "assigned_road_marking_polygonal";
const std::string ROLE_ASSIGNED_ROAD_MARKING_POINT_LANE_DIRECTION = "assigned_road_marking_point_lane_direction";
const std::string ROLE_ASSIGNED_ROAD_MARKING_POINT_SYMBOL = "assigned_road_marking_point_symbol";
const std::string ROLE_ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN = "assigned_road_marking_point_road_sign";
const std::string ROLE_ASSIGNED_ROAD_MARKING_POINT_ROAD_SIGN_SPEED_LIMIT = "assigned_road_marking_point_road_sign_speed_limit";
const std::string ROLE_ASSIGNED_ROAD_MARKING_POINT_TEXT = "assigned_road_marking_point_text";
const std::string ROLE_ASSIGNED_THREAD = "assigned_thread";
const std::string ROLE_ASSIGNED_THREAD_STOP = "assigned_thread_stop";
const std::string ROLE_ASSIGNED_TRAM = "assigned_tram";
const std::string ROLE_ASSIGNED_WATERWAY = "assigned_waterway";
const std::string ROLE_SRC_THREAD = "src_thread";
const std::string ROLE_DST_THREAD = "dst_thread";
const std::string ROLE_ASSOCIATED_WITH = "associated_with";
const std::string ROLE_BOARDING = "boarding";
const std::string ROLE_BUS_PART = "bus_part";
const std::string ROLE_CENTER = "center";
const std::string ROLE_CHILD = "child";
const std::string ROLE_COND_CLOSURE_ELEMENT = "element";
const std::string ROLE_COND_CLOSURE_FROM = "from";
const std::string ROLE_CONTROLLED = "controlled";
const std::string ROLE_ENTRANCE_ASSIGNED = "entrance_assigned";
const std::string ROLE_EXCLUSION = "exclusion";
const std::string ROLE_EXIT = "exit";
const std::string ROLE_FC_PART = "fc_part";
const std::string ROLE_FLAT_RANGE_ASSIGNED = "flat_range_assigned";
const std::string ROLE_FROM = "from";
const std::string ROLE_LN_PART = "ln_part";
const std::string ROLE_LOCATED_AT = "located_at";
const std::string ROLE_MRC_PEDESTRIAN_REGION_ASSOCIATED_WITH = "mrc_pedestrian_region_associated_with";
const std::string ROLE_PARKING_LOT_ASSIGNED = "parking_lot_assigned";
const std::string ROLE_PARKING_LOT_LINEAR_ASSIGNED = "parking_lot_linear_assigned";
const std::string ROLE_PART = "part";
const std::string ROLE_PLACED_AT = "placed_at";
const std::string ROLE_PREVIOUS = "previous";
const std::string ROLE_RASP_PART = "rasp_part";
const std::string ROLE_RD_ASSOCIATED_WITH = "rd_associated_with";
const std::string ROLE_SPORT_TRACK_ASSOCIATED_WITH = "sport_track_associated_with";
const std::string ROLE_SPORT_TRACK_PART = "sport_track_part";
const std::string ROLE_STATION = "station";
const std::string ROLE_STATION_A = "station_a";
const std::string ROLE_STATION_B = "station_b";
const std::string ROLE_STATION_PREVIOUS = "station_previous";
const std::string ROLE_STATION_NEXT = "station_next";
const std::string ROLE_SUBSTITUTION = "substitution";
const std::string ROLE_SUBST_CHILD = "ad_subst_child";
const std::string ROLE_TO = "to";
const std::string ROLE_URBAN_AREAL_ASSIGNED = "urban_areal_assigned";
const std::string ROLE_VIA = "via";
const std::string ROLE_ASSIGNED_INDOOR_POI_AUTO = "assigned_indoor_poi_auto";
const std::string ROLE_ASSIGNED_INDOOR_POI_EDU = "assigned_indoor_poi_edu";
const std::string ROLE_ASSIGNED_INDOOR_POI_FINANCE = "assigned_indoor_poi_finance";
const std::string ROLE_ASSIGNED_INDOOR_POI_FOOD = "assigned_indoor_poi_food";
const std::string ROLE_ASSIGNED_INDOOR_POI_GOVERMENT = "assigned_indoor_poi_goverment";
const std::string ROLE_ASSIGNED_INDOOR_POI_INFO = "assigned_indoor_poi_info";
const std::string ROLE_ASSIGNED_INDOOR_POI_INFRA = "assigned_indoor_poi_infra";
const std::string ROLE_ASSIGNED_INDOOR_POI_LEISURE = "assigned_indoor_poi_leisure";
const std::string ROLE_ASSIGNED_INDOOR_POI_MEDICINE = "assigned_indoor_poi_medicine";
const std::string ROLE_ASSIGNED_INDOOR_POI_SERVICE = "assigned_indoor_poi_service";
const std::string ROLE_ASSIGNED_INDOOR_POI_SPORT = "assigned_indoor_poi_sport";
const std::string ROLE_ASSIGNED_INDOOR_POI_SHOPPING = "assigned_indoor_poi_shopping";
const std::string ROLE_ASSIGNED_INDOOR_POI_RELIGION = "assigned_indoor_poi_religion";
const std::string ROLE_RESTRICTS = "restricts";
const std::string ROLE_RESTRICTS_FROM = "restricts_from";
const std::string ROLE_RESTRICTS_TO = "restricts_to";

const std::string RELATION_PREFIX = "rel:";
const std::string CATEGORY_PREFIX = "cat:";
} // namespace wiki
} // namespace maps
