#include "contours.h"
namespace maps
{
namespace wiki
{
ContourObjectsDefs::ContourObjectsDefs(const maps::xml3::Node& node)
{
    maps::xml3::Node objNode = node.firstElementChild("contour-object");
    while (!objNode.isNull()) {
        maps::xml3::Node contourNode = objNode.firstElementChild("contour");
        REQUIRE(!contourNode.isNull(), "contour node required for contour object definition.");
        maps::xml3::Node elementNode = contourNode.firstElementChild("linear-element");
        REQUIRE(!elementNode.isNull(), "linear-element  node required for contour definition.");
        contourObjectsDefs_.push_back(
            ContourObjectDef {
                ContourDef {
                    LinearElementDef {
                        elementNode.attr<std::string>("role-id"),
                        elementNode.attr<std::string>("category-id")
                    },
                    contourNode.attr<std::string>("role-id"),
                    contourNode.attr<std::string>("category-id")
                },
                objNode.attr<std::string>("category-id"),
                boost::none
            }
        );
        auto& contourObjectDef = contourObjectsDefs_.back();
        size_t index = contourObjectsDefs_.size() - 1;
        contourObjectsDefsByCategories_.insert({contourObjectDef.categoryId, index});
        contourObjectsDefsByCategories_.insert({contourObjectDef.contour.categoryId, index});
        contourObjectsDefsByCategories_.insert({contourObjectDef.contour.linearElement.categoryId, index});
        
        maps::xml3::Node centerNode = objNode.firstElementChild("center");
        if (!centerNode.isNull()) {
            contourObjectDef.center = CenterDef
                    {
                        centerNode.attr<std::string>("role-id"),
                        centerNode.attr<std::string>("category-id")
                    };
            contourObjectsDefsByCategories_.insert({contourObjectDef.center->categoryId, index});
        }        
        objNode = objNode.nextElementSibling("contour-object");
    }
}

ContourObjectsDefs::PartType
ContourObjectsDefs::partType(const std::string& categoryId) const
{
    auto it = contourObjectsDefsByCategories_.find(categoryId);
    if (it == contourObjectsDefsByCategories_.end()) {
        return PartType::None;
    }
    const auto& contourObjectDef = contourObjectsDefs_[it->second];
    if (contourObjectDef.contour.categoryId == categoryId) {
        return PartType::Contour;
    }
    if (contourObjectDef.contour.linearElement.categoryId == categoryId) {
        return PartType::LinearElement;
    }
    if (contourObjectDef.categoryId == categoryId) {
        return PartType::Object;
    }
    if (contourObjectDef.center && contourObjectDef.center->categoryId == categoryId) {
        return PartType::Center;
    }
    return PartType::None;
}

const ContourObjectsDefs::ContourObjectDef&
ContourObjectsDefs::contourDef(const std::string& categoryId) const
{
    auto it = contourObjectsDefsByCategories_.find(categoryId);
    REQUIRE(it != contourObjectsDefsByCategories_.end(), 
        "Category " + categoryId + " is not associated with any contour object definition.");
    return contourObjectsDefs_[it->second];
}



}//wiki
}//maps
