#pragma once
#include <maps/libs/xml/include/xml.h>
#include <boost/optional.hpp>
#include <vector>
#include <string>
#include <map>

namespace maps
{
namespace wiki
{
class ContourObjectsDefs
{
public:
    enum class PartType
    {
        Object,
        Contour,
        LinearElement,
        Center,
        None
    };

    struct LinearElementDef
    {
        std::string roleId;
        std::string categoryId;
    };

    struct ContourDef
    {
        LinearElementDef linearElement;
        std::string roleId;
        std::string categoryId;
    };

    struct CenterDef
    {
        std::string roleId;
        std::string categoryId;
    };

    struct ContourObjectDef
    {
        ContourDef contour;
        std::string categoryId;
        boost::optional<CenterDef> center;
    };

    explicit ContourObjectsDefs(const maps::xml3::Node& node);
    ContourObjectsDefs() {}

    PartType partType(const std::string& categoryId) const;
    const ContourObjectDef& contourDef(const std::string& categoryId) const;

private:
    std::vector<ContourObjectDef> contourObjectsDefs_;
    std::map<std::string, size_t> contourObjectsDefsByCategories_;

};
}//wiki
}//maps

