#include "editor_cfg.h"
#include <maps/wikimap/mapspro/services/editor/src/exception.h>
#include <maps/wikimap/mapspro/services/editor/src/srv_attrs/registry.h>

#include <yandex/maps/wiki/configs/editor/categories.h>
#include <maps/libs/tile/include/utils.h>

namespace maps {
namespace wiki {

EditorCfg::EditorCfg(const std::string& path)
    : ConfigHolder(path)
    , minGeneralizationZmin_(MAX_ZOOM)
{
    auto node = doc().node("/editor");

    system_.reset(new System(node.node("system")));

    const maps::xml3::Nodes generalizations = node.nodes("generalizations/generalization");
    for (size_t i = 0; i < generalizations.size(); i++) {
        std::string id = generalizations[i].attr<std::string>("id");
        std::unique_ptr<Generalization> generalization(
            new Generalization(generalizations[i]));
        minGeneralizationZmin_ = std::min(minGeneralizationZmin_, generalization->zmin());
        generalizations_.insert(id, generalization.release());
    }

    objectsUpdateRestrictions_.reset(new ObjectsUpdateRestrictions(node));

    const maps::xml3::Node parentRelationDefsNode = node.node("parent-relation-definitions", true);
    if (!parentRelationDefsNode.isNull()) {
        parentRelationDefs_ = ParentRelationDefs(parentRelationDefsNode);
    }

    const maps::xml3::Node contourObjectsNode = node.node("contour-objects", true);
    if (!contourObjectsNode.isNull()) {
        ContourObjectsDefs o(contourObjectsNode);
        std::swap(contourObjectsDefs_, o);
    }
}

const Generalization*
EditorCfg::generalization(const std::string& id) const
{
    Generalizations::const_iterator it = generalizations_.find(id);
    if(it == generalizations_.end()) {
        THROW_WIKI_INTERNAL_ERROR("Generalization '" << id << "' not found.");
    }
    return it->second;
}

void
EditorCfg::onLoad()
{
    srv_attrs::ServiceAttributesRegistry::init(*this);
}

} // namespace wiki
} // namespace maps
