#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include "categories.h"
#include "parent_relation_defs.h"
#include "generalization.h"
#include "objects_update_restrictions.h"
#include "contours.h"
#include <yandex/maps/wiki/configs/editor/countries.h>
#include <yandex/maps/wiki/configs/editor/externals.h>

#include <yandex/maps/wiki/configs/editor/config_holder.h>

#include <boost/optional.hpp>
#include <boost/ptr_container/ptr_map.hpp>

#include <memory>
#include <map>
#include <vector>

namespace maps {
namespace wiki {

class EditorCfg : public ConfigHolder
{
public:
    // C-tor
    // @param path - path to main wikimaps file
    explicit EditorCfg(const std::string& path);

    const Generalization* generalization(const std::string& id) const;
    TZoom minGeneralizationZmin() const { return minGeneralizationZmin_; }

    const System& system() const { return *system_; }

    const boost::optional<ParentRelationDefs>& parentRelationDefs() const
    {
        return parentRelationDefs_;
    }

    void onLoad();

    const ObjectsUpdateRestrictions& objectsUpdateRestrictions() const
    {
        return *objectsUpdateRestrictions_;
    }

    const ContourObjectsDefs& contourObjectsDefs() const { return contourObjectsDefs_; }

private:
    typedef boost::ptr_map<std::string, Generalization> Generalizations;

    std::unique_ptr<System> system_;
    Generalizations generalizations_;
    boost::optional<ParentRelationDefs> parentRelationDefs_;
    std::unique_ptr<ObjectsUpdateRestrictions> objectsUpdateRestrictions_;
    ContourObjectsDefs contourObjectsDefs_;
    TZoom minGeneralizationZmin_;
};

} // namespace wiki
} // namespace maps
