#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <string>

namespace maps {

namespace xml3 {
class Node;
}

namespace wiki {

class GeoObjectCollection;

struct ObjectsUpdateActionRestrictions {
    bool allowMultipleCategories;
    bool allowJunction;
    bool allowPoint;
    bool allowLinearElement;
    bool allowAreal;
    bool allowModel3d;
    bool allowLineObject;

    size_t maxObjects;
    StringSet categoryIds;
};

class ObjectsUpdateRestrictions
{
public:
    enum class CategoriesCheckPolicy
    {
        ListedOnly,
        Any
    };
    explicit ObjectsUpdateRestrictions(const maps::xml3::Node& nodeEditor);

    const std::map<std::string, StringSet>& groupAttrIdsByCategoryId() const
    {
        return groupAttrIdsByCategoryId_;
    }

    const StringSet& actionCategoryIds(const std::string& actionId) const;

    size_t maxObjects(const std::string& actionId) const;
    void checkObjects(
        const std::string& actionId,
        const GeoObjectCollection& collection,
        CategoriesCheckPolicy categoriesCheckPolicy = CategoriesCheckPolicy::Any) const;

    StringSet allowedCategoryIds(const std::string& actionId) const;

private:
    std::map<std::string, ObjectsUpdateActionRestrictions> restrictionsByActionId_;
    std::map<std::string, StringSet> groupAttrIdsByCategoryId_;

};
} // namespace wiki
} // namespace maps
