#pragma once
#include <maps/wikimap/mapspro/services/editor/src/relation_infos.h>

#include <maps/libs/xml/include/xml.h>
#include <boost/optional.hpp>
#include <string>
#include <list>
#include <map>

namespace maps {
namespace wiki {

const size_t MAX_PARENT_PATH_LEVELS = 20;

class ParentRelationDefs
{
public:
    struct Parent
    {
        std::string categoryId;
        std::string roleId;
        RelationType relationType;
    };

    explicit ParentRelationDefs(const maps::xml3::Node& node);

    boost::optional<const Parent&> parentDefinition(const std::string& categoryId) const;

private:
    typedef std::map<std::string, Parent> MapParentsByCategory;
    MapParentsByCategory parentDefinitions_;

    void parseParents(const maps::xml3::Node& categoryNode,
                                  const std::string& parentNodeName,
                                  MapParentsByCategory& target);

};

}//wiki
}//maps
