#pragma once

#include <maps/libs/xml/include/xml.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/rate_limiter.h>
#include <memory>

namespace maps::wiki {

class BranchContext;

class RateLimiter
{
public:
    explicit RateLimiter(const maps::xml3::Node& node);
    ~RateLimiter();

    void checkUserActivityAndRestrict(
        const BranchContext& branchCtx,
        social::TUid uid,
        social::ActivityType type,
        const std::string& moderationStatus) const;

    bool areRpsChecksEnabled() const { return rpsCounters_.get() != nullptr; }

    void checkUserReadActivityDeleteAndRestrict(
        social::TUid uid,
        const std::string& handle,
        const std::string& params) const;

private:
    social::RateLimiter rateLimiter_;

    class RpsCounters;
    std::unique_ptr<RpsCounters> rpsCounters_;
};

} // namespace maps::wiki

