#include "context.h"
#include "exception.h"
#include "objects/object.h"
#include "configs/config.h"
#include "objects_cache.h"

#include <maps/libs/log8/include/log8.h>

#include <boost/algorithm/string.hpp>

namespace maps {
namespace wiki {

Context::Context(ObjectsCache& cache, TUid user)
    : cache_(cache)
    , user_(user)
    , forceSave_(true)
{}

void
Context::forceSave(bool f)
{
    forceSave_ = f;
}

bool
Context::forceSave() const
{
    return forceSave_;
}

ObjectsCache&
Context::cache() const
{
    return cache_;
}

TUid
Context::user() const
{
    return user_;
}


bool
Context::hasEditContext(UniqueId oid) const
{
    return objectsEditContexts_.count(oid);
}

const ObjectEditContext*
Context::editContext(UniqueId oid) const
{
    auto it = objectsEditContexts_.find(oid);
    if (it == objectsEditContexts_.end()) {
        THROW_WIKI_INTERNAL_ERROR("No edit-context passed with object: " << oid);
    }
    return it->second.get();
}

void
Context::addEditContext(UniqueId oid, ObjectEditContextPtr newEditContext)
{
    REQUIRE(newEditContext, "Null edit context passed for object " << oid);
    objectsEditContexts_.insert({oid, newEditContext});
}

TZoom
Context::maxViewZoom() const
{
    TZoom maxZoom = 0;
    for (const auto& [_, objectsEditContext] : objectsEditContexts_) {
        maxZoom = std::max(maxZoom, objectsEditContext->viewZoom());
    }
    return maxZoom;
}

} // namespace wiki
} // namespace maps
