#pragma once

#include "common.h"

namespace maps {
namespace wiki {

class GeoObject;

namespace edit_notes {
// https://wiki.yandex-team.ru/maps/dev/core/wikimap/mapspro/object_history
const std::string CREATED = "created";
const std::string DELETED = "deleted";
const std::string MODIFIED = "modified";
const std::string REVERTED = "reverted";
const std::string CREATED_SPLIT = "created-split";
const std::string MODIFIED_SPLIT = "modified-split";
const std::string MODIFIED_BLOCKED = "modified-blocked";
const std::string MODIFIED_UNBLOCKED = "modified-unblocked";
const std::string MODIFIED_CATEGORY = "modified-category";
const std::string MODIFIED_ATTRIBUTES = "modified-attributes";
const std::string MODIFIED_ATTRIBUTES_OTHER = "modified-attributes-other";
const std::string MODIFIED_ATTRIBUTES_TAGS = "modified-attributes-tags";
const std::string MODIFIED_ATTRIBUTES_NAMES = "modified-attributes-names";
const std::string MODIFIED_ATTRIBUTES_NAMES_OFFICIAL = "modified-attributes-names-official";
const std::string MODIFIED_ATTRIBUTES_NAMES_OFFICIAL_ADDED = "modified-attributes-names-official-added";
const std::string MODIFIED_ATTRIBUTES_NAMES_OFFICIAL_REMOVED = "modified-attributes-names-official-removed";
const std::string MODIFIED_ATTRIBUTES_NAMES_ALTERNATIVE = "modified-attributes-names-alternative";
const std::string MODIFIED_ATTRIBUTES_NAMES_ALTERNATIVE_ADDED = "modified-attributes-names-alternative-added";
const std::string MODIFIED_ATTRIBUTES_NAMES_ALTERNATIVE_REMOVED = "modified-attributes-names-alternative-removed";
const std::string MODIFIED_GEOMETRY = "modified-geometry";
const std::string MODIFIED_GEOMETRY_ELEMENTS = "modified-geometry-elements";
const std::string MODIFIED_GEOMETRY_ELEMENTS_ADDED = "modified-geometry-elements-added";
const std::string MODIFIED_GEOMETRY_ELEMENTS_REMOVED = "modified-geometry-elements-removed";
const std::string MODIFIED_GEOMETRY_CONTOURS = "modified-geometry-contours";
const std::string MODIFIED_GEOMETRY_CONTOURS_ADDED = "modified-geometry-contours-added";
const std::string MODIFIED_GEOMETRY_CONTOURS_REMOVED = "modified-geometry-contours-removed";
const std::string MODIFIED_GEOMETRY_CENTER = "modified-geometry-center";
const std::string MODIFIED_GEOMETRY_CENTER_ADDED = "modified-geometry-center-added";
const std::string MODIFIED_GEOMETRY_CENTER_REMOVED = "modified-geometry-center-removed";
const std::string MODIFIED_DESCRIPTION = "modified-description";
const std::string MODIFIED_RELATIONS = "modified-relations";
const std::string MODIFIED_RELATIONS_MASTERS = "modified-relations-masters";
const std::string MODIFIED_RELATIONS_MASTERS_ADDED = "modified-relations-masters-added";
const std::string MODIFIED_RELATIONS_MASTERS_ADDED_CREATED = "modified-relations-masters-added-created";
const std::string MODIFIED_RELATIONS_MASTERS_REMOVED = "modified-relations-masters-removed";
const std::string MODIFIED_RELATIONS_SLAVES = "modified-relations-slaves";
const std::string MODIFIED_RELATIONS_SLAVES_ADDED = "modified-relations-slaves-added";
const std::string MODIFIED_RELATIONS_SLAVES_REMOVED = "modified-relations-slaves-removed";
const std::string MODIFIED_RELATIONS_SLAVES_GEOMETRY = "modified-relations-slaves-geometry";

StringSet editNotes(const GeoObject* object, const TOIds& modifiedGeomElementsObjects);

struct EditNotesTree
{
    struct Node
    {
        std::string note;
        std::vector<Node> subNotes;
    };
    std::vector<Node> rootNotes;
};

EditNotesTree
treeRepresentation(const StringSet& editNotesSet);


}//edit_notes
}//namespace wiki
}//namespace maps
