#include "exception.h"

namespace maps::wiki {

void
exceptionToStream(std::ostream& out, const maps::Exception& ex, bool withBacktrace)
{
    auto cause = ex.cause();
    if (cause) {
        exceptionToStream(out, *cause, withBacktrace);
    }

    if (withBacktrace) {
        out << ex;
    } else {
        out << ex.what() << '\n';
    }
}

} // namespace maps::wiki
