#pragma once

#include "common.h"
#include <atomic>

namespace maps {
namespace wiki {

class ExecutionState
{
public:
    ExecutionState()
        : fail(false)
        , cancel(false)
    {}
    virtual ~ExecutionState() {}

    bool isOk() const { return !fail && !cancel; }
    virtual bool checkOk(Transaction& /* workCore */ ) { return isOk(); }

    void clear()
    {
        fail = false;
        cancel = false;
    }

    std::atomic<bool> fail;
    std::atomic<bool> cancel;
};
typedef std::shared_ptr<ExecutionState> ExecutionStatePtr;

} // namespace wiki
} // namespace maps
