#pragma once

#include "objectclassinfo.h"
#include "objects/object.h"

namespace maps {
namespace wiki {

namespace revision {

class ObjectRevision;

} // namespace revision

class ObjectsCache;

class GeoObjectFactory
{
public:
    explicit GeoObjectFactory(ObjectsCache& cache);

    ObjectPtr createNewObject(
        const ObjectsClassInfo& objectClass,
        const std::string& category) const;

    ObjectPtr cloneObject(const ObjectPtr& original) const;

    ObjectPtr createObject(
        const revision::ObjectRevision& objectRev,
        const ObjectsClassInfo& objectClass) const;

    static const ObjectsClassInfo& objectClass(const std::string& categoryId);

private:
    friend class TopoStorage;

    ObjectPtr create(const ObjectsClassInfo& objectClass, TRevisionId revisionId) const;

    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
