#include "format.h"
#include "exception.h"
#include "configs/config.h"
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <boost/algorithm/string.hpp>
#include <boost/current_function.hpp>

namespace maps::wiki {

void Format::fromNode(maps::xml3::Node& node)
{
    maps::xml3::Node childNode = node.firstElementChild();
    while(!childNode.isNull()){
        std::string name = childNode.name();
        if(name == "A"){
            formatSpec_.push_back(StringPart(childNode.value<std::string>(), true));
        } else if(name == "T"){
            formatSpec_.push_back(StringPart(childNode.value<std::string>(), false));
        }else {
            THROW_WIKI_LOGIC_ERROR(ERR_WRONG_FORMAT_SETTING, "Unexpected node name:" << name);
        }
        childNode = childNode.nextElementSibling();
    }
}

Format::Format(maps::xml3::Node &node)
{
    fromNode(node);
}


Format::Format(const std::string &xml)
{
    maps::xml3::Doc doc = maps::xml3::Doc::fromString(xml);
    maps::xml3::Node node = doc.node("//Format");
    fromNode(node);
}

class isMyChar
{
public:
    isMyChar(char c):c_(c){};
    bool operator ()(char t)const{return t == c_;};
private:
    char c_;
};

Format::Format(const std::string &format, char shield)
{
    if(format.empty())
        THROW_WIKI_LOGIC_ERROR(ERR_WRONG_FORMAT_SETTING, "Empty string as format spec");
    bool attr = false;
    std::vector<std::string> parts;
    boost::split(parts, format, isMyChar(shield));
    for(size_t i = 0; i < parts.size(); i++){
        formatSpec_.push_back(StringPart(parts[i], attr));
        attr = !attr;
    }
}

std::string
valueLabel(const std::string& attrName, const std::string& value)
{
    if (!cfg()->editor()->isAttributeDefined(attrName)) {
        return value;
    }
    const AttrDefPtr& attr = cfg()->editor()->attribute(attrName);
    auto it = std::find(attr->values().begin(), attr->values().end(), value);
    if (it != attr->values().end() && it->label.length()){
        return it->label;
    }
    return value;
}

const std::string&
categoryLabel(const std::string& categoryId)
{
    return cfg()->editor()->categories()[categoryId].label();
}

} // namespace maps::wiki
