#pragma once
#include <maps/libs/xml/include/xml.h>
#include <iostream>
#include <string>
#include <vector>


namespace maps
{
namespace wiki
{

class StringPart
{
public:
    StringPart(std::string value, bool attrRef):value_(value), attrRef_(attrRef){};

    std::string value_;
    bool attrRef_;
};

std::string
valueLabel(const std::string& attrName, const std::string& value);
const std::string& categoryLabel(const std::string& categoryId);

template <class T> std::string
attributeValueLabel(const T& obj, const std::string& name)
{
    return valueLabel(obj.value(name));
}

class Format
{
public:
    Format(const std::string& format, char shield);
    Format(const std::string& xml);
    Format(maps::xml3::Node& node);
    template <class T> void operator()(const T& obj, std::ostream& os) const
    {
        for(size_t p = 0; p < formatSpec_.size(); p++){
            if(formatSpec_[p].attrRef_){
                os << attributeValueLabel<T>(obj, formatSpec_[p].value_);
            } else{
                os <<  formatSpec_[p].value_;
            }
        }

    };

private:
    void fromNode(maps::xml3::Node& node);
    std::vector<StringPart> formatSpec_;
};
}//namespace wiki
}//namespace maps;
