OWNER(g:maps-nmaps)

LIBRARY()

PEERDIR(
    contrib/restricted/boost/libs
    contrib/libs/geos
    contrib/libs/icu
    maps/libs/auth
    maps/libs/chrono
    maps/libs/common
    maps/libs/locale
    maps/libs/log8
    maps/libs/pgpool
    maps/libs/tile
    maps/renderer/libs/tilerenderer
    maps/wikimap/mapspro/libs/acl
    maps/wikimap/mapspro/libs/acl_utils
    maps/wikimap/mapspro/libs/controller
    maps/wikimap/mapspro/libs/common
    maps/wikimap/mapspro/libs/configs_editor
    maps/wikimap/mapspro/libs/dbutils
    maps/wikimap/mapspro/libs/diffalert
    maps/wikimap/mapspro/libs/graph
    maps/wikimap/mapspro/libs/misc_point_to_bld
    maps/wikimap/mapspro/libs/poi_conflicts
    maps/wikimap/mapspro/libs/revision
    maps/wikimap/mapspro/libs/revision_meta
    maps/wikimap/mapspro/libs/routing
    maps/wikimap/mapspro/libs/social
    maps/wikimap/mapspro/libs/taskutils
    maps/wikimap/mapspro/libs/topological
    maps/wikimap/mapspro/libs/validator
    maps/wikimap/mapspro/libs/views
)

SRCDIR(maps/wikimap/mapspro/services/editor/src)

SRCS(
    actions/routing/common.cpp
    actions/routing/config.cpp
    actions/routing/dynamic_route_graph.cpp
    actions/routing/helper.cpp
    actions/routing/junction_geom_index.cpp
    actions/routing/route_condition.cpp
    actions/routing/route_element.cpp
    actions/routing/route_object.cpp
    actions/routing/thread_stop.cpp
    actions/routing/util.cpp

    approved_commits/approver.cpp
    approved_commits/processor.cpp
    approved_commits/updater.cpp

    background_tasks/deleted_users_cache_updater.cpp
    background_tasks/monitoring.cpp
    background_tasks/sprav_tasks_updater.cpp
    background_tasks/suspicious_users_table_cleaner.cpp

    configs/categories.cpp
    configs/config.cpp
    configs/contours.cpp
    configs/editor_cfg.cpp
    configs/generalization.cpp
    configs/objects_update_restrictions.cpp
    configs/parent_relation_defs.cpp
    configs/rate_limiter.cpp

    objects/areal_object.cpp
    objects/attr_object.cpp
    objects/category_traits.cpp
    objects/complex_object.cpp
    objects/helpers.cpp
    objects/junction.cpp
    objects/line_object.cpp
    objects/linear_element.cpp
    objects/model_object.cpp
    objects/object.cpp
    objects/point_object.cpp
    objects/relation_object.cpp

    observers/observer.cpp
    observers/renderer.cpp
    observers/view_syncronizer.cpp

    revision_meta/bbox_context.cpp
    revision_meta/bbox_helpers.cpp
    revision_meta/bbox_provider.cpp
    revision_meta/bbox_update_task.cpp
    revision_meta/bbox_writer.cpp
    revision_meta/categories_holder.cpp
    revision_meta/complex_object_bbox_computer.cpp
    revision_meta/complex_objects_loader.cpp
    revision_meta/filter_helpers.cpp
    revision_meta/update_queue.cpp
    revision_meta/updater.cpp

    sprav/sprav_task.cpp
    srv_attrs/ad.cpp
    srv_attrs/calc.cpp
    srv_attrs/generic.cpp
    srv_attrs/hd_map.cpp
    srv_attrs/hydro.cpp
    srv_attrs/indoor.cpp
    srv_attrs/metro.cpp
    srv_attrs/misc.cpp
    srv_attrs/object_predicates.cpp
    srv_attrs/railway.cpp
    srv_attrs/rd.cpp
    srv_attrs/registry.cpp
    srv_attrs/relations_path.cpp
    srv_attrs/transport_thread.cpp
    srv_attrs/urban.cpp

    sync/branch_mask.cpp
    sync/create_schema.cpp
    sync/db_helpers.cpp
    sync/lock_helpers.cpp
    sync/dependent_info.cpp
    sync/sync_objects.cpp
    sync/sync_params.cpp
    sync/sync_processor.cpp
    sync/sync_view.cpp
    sync/sync_attrs.cpp
    sync/target_tables.cpp
    sync/tasks.cpp

    views/objects_base.cpp
    views/objects_c.cpp
    views/objects_p.cpp
    views/objects_l.cpp
    views/objects_a.cpp
    views/objects_r.cpp
    views/objects_query.cpp
    views/view_object.cpp

    acl_role_info.cpp
    acl_utils.cpp
    approve_status.cpp
    attributes.cpp
    branch_helpers.cpp
    check_outsource_consistency.cpp
    check_permissions.cpp
    collection.cpp
    commit.cpp
    context.cpp
    edit_notes.cpp
    edit_options.cpp
    exception.cpp
    factory.cpp
    format.cpp
    geom.cpp
    last_commits.cpp
    moderation.cpp
    moderation_log.cpp
    object_update_data.cpp
    objectclassinfo.cpp
    objects_cache.cpp
    relation_infos.cpp
    relations_manager.cpp
    relations_processor.cpp
    rendererlayerstraverse.cpp
    rendererpool.cpp
    revisions_facade.cpp
    runtime_data.cpp
    shadow_attributes.cpp
    tablevalues.cpp
    topo_storage.cpp
    topological/topo_cache.cpp
    utils.cpp
    validator.cpp
    view.cpp
    view_utils.cpp
)

END()
