#pragma once

#include "common.h"

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/social/moderation.h>

#include <map>

namespace maps::wiki::moderation {

using String2ModerationMode = std::map<std::string, social::ModerationMode>;
const String2ModerationMode& getModerationModeResolver();

std::string toAclRoleName(social::ModerationMode mode);

// The enum must be sorted from the most untrusted level towards the
// most trusted level, so levels can be compared.
enum class TrustLevel
{
    NotTrusted,
    AcceptAndModerate,
    SkipModeration
};

StringSet getAutoModeratedCategoryIds(
    const acl::User& user,
    const TOIds& aoiIds);

bool isAutoApprovable(const ObjectPtr& primaryObj);

enum class ResolveLockedByOther { No, Yes };

ResolveLockedByOther canResolveLockedByOther(bool isUserCartographer);

} // namespace maps::wiki::moderation
