#pragma once

#include "configs/config.h"

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/threadutils/threadedqueue.hpp>

#include <atomic>
#include <fstream>
#include <iosfwd>
#include <string>
#include <thread>

namespace maps {
namespace wiki {

class ModerationLogger
{
public:
    explicit ModerationLogger(const std::string& logPath);
    ~ModerationLogger();

    enum class Action {
        Created,
        Resolved,
        Closed
    };

    struct Event {
        social::TId taskId;
        Action action;
    };

    void log(Event event);
    void log(social::TId taskId, Action action);
    void log(const social::TIds& taskIds, Action action);

    void onLogrotate();

private:
    void writeLog() noexcept;

    const std::string logPath_;
    std::atomic_bool reopenFlag_;
    std::ofstream logStream_;
    ThreadedQueue<Event> eventsQueue_;
    std::thread writerThread_;
};

std::ostream& operator << (std::ostream&, ModerationLogger::Action);

template<typename TaskIds>
inline void logModerationEvent(
        const TaskIds& taskIds,
        ModerationLogger::Action action)
{
    if (cfg()->moderationLogger()) {
        cfg()->moderationLogger()->log(taskIds, action);
    }
}

} // namespace wiki
} // namespace maps
