#include "objectclassinfo.h"
#include "objects_cache.h"
#include "exception.h"

//object classes
#include "objects/areal_object.h"
#include "objects/point_object.h"
#include "objects/junction.h"
#include "objects/linear_element.h"
#include "objects/line_object.h"
#include "objects/complex_object.h"
#include "objects/attr_object.h"
#include "objects/relation_object.h"
#include "objects/model_object.h"

#include <maps/wikimap/mapspro/libs/views/include/magic_strings.h>


namespace maps {
namespace wiki {

namespace {

template <class T>
class Constructor
{
public:
    static ObjectPtr create(const TRevisionId& id, ObjectsCache& cache)
    {
        return std::make_shared<T>(id, cache);
    }
};

}

//!TODO: Use table names from this structure in all queries.
const ObjectsClassInfo& ObjectsClassInfos::arealClassInfo
    = {"areal", views::TABLE_OBJECTS_A, Constructor<ArealObject>::create};
const ObjectsClassInfo& ObjectsClassInfos::pointClassInfo
    = {"point", views::TABLE_OBJECTS_P, Constructor<PointObject>::create};
const ObjectsClassInfo& ObjectsClassInfos::junctionClassInfo
    = {"junction", views::TABLE_OBJECTS_P, Constructor<Junction>::create};
const ObjectsClassInfo& ObjectsClassInfos::linearElementClassInfo
    = {"linearElement", views::TABLE_OBJECTS_L, Constructor<LinearElement>::create};
const ObjectsClassInfo& ObjectsClassInfos::lineClassInfo
    = {"line", views::TABLE_OBJECTS_L, Constructor<LineObject>::create};
const ObjectsClassInfo& ObjectsClassInfos::complexClassInfo
    = {"complex", views::TABLE_OBJECTS_C, Constructor<ComplexObject>::create};
const ObjectsClassInfo& ObjectsClassInfos::attributesClassInfo
    = {"attributes", s_emptyString, Constructor<AttrObject>::create};
const ObjectsClassInfo& ObjectsClassInfos::relationClassInfo
    = {"relation", views::TABLE_OBJECTS_R, Constructor<RelationObject>::create};
const ObjectsClassInfo& ObjectsClassInfos::model3dClassInfo
    = {"model3d", s_emptyString, Constructor<Model3dObject>::create};

} // namespace wiki
} // namespace maps
