#pragma once

#include "common.h"

#include <string>
#include <map>

namespace maps {
namespace wiki {

class ObjectsCache;
typedef ObjectPtr (*ConstructorPtr)(const TRevisionId& id, ObjectsCache&);

struct ObjectsClassInfo
{
    std::string className;
    std::string tableName;
    ConstructorPtr creator;
};

//thegeorg@FIXME: it's strange to have class containing static functions only
class ObjectsClassInfos
{
public:
    ObjectsClassInfos() = delete;

    static const ObjectsClassInfo& arealClassInfo;
    static const ObjectsClassInfo& pointClassInfo;
    static const ObjectsClassInfo& junctionClassInfo;
    static const ObjectsClassInfo& linearElementClassInfo;
    static const ObjectsClassInfo& lineClassInfo;
    static const ObjectsClassInfo& complexClassInfo;
    static const ObjectsClassInfo& attributesClassInfo;
    static const ObjectsClassInfo& relationClassInfo;
    static const ObjectsClassInfo& model3dClassInfo;
};

} // namespace wiki
} // namespace maps
