#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>
#include <maps/wikimap/mapspro/services/editor/src/views/fwd.h>

namespace maps {
namespace wiki {

class ObjectsCache;

class ArealObject : public GeoObject
{
public:
    using ViewType = views::ArealViewObject;

    ArealObject(const TRevisionId& id, ObjectsCache& cache);

    double area() const { return geom_.isNull() ? 0 : geom_->getArea(); }

    virtual const std::string& tablename() const
    { return ObjectsClassInfos::arealClassInfo.tableName; }

    virtual ObjectPtr clone() const
    {
        return ObjectPtr(new ArealObject(*this));
    }

protected:
    //From GeoObject
    virtual void applyVisitor(ObjectVisitor& visitor) const;
    virtual void applyProcessor(ObjectProcessor& processor);
};

} // namespace wiki
} // namespace maps
