#include <maps/wikimap/mapspro/services/editor/src/objects/attr_object.h>
#include <maps/wikimap/mapspro/services/editor/src/exception.h>
#include <maps/wikimap/mapspro/services/editor/src/factory.h>
#include <maps/wikimap/mapspro/services/editor/src/collection.h>
#include <maps/wikimap/mapspro/services/editor/src/objectvisitor.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <maps/libs/log8/include/log8.h>

#include <cmath>

namespace maps {
namespace wiki {

AttrObject::AttrObject(const TRevisionId& id, ObjectsCache& cache)
    : GeoObject(id, cache)
{}

void
AttrObject::generalize(Transaction&)
{}

void
AttrObject::applyVisitor(ObjectVisitor& visitor) const
{
    visitor.visitAttrObject(this);
}

void
AttrObject::applyProcessor(ObjectProcessor& processor)
{
    processor.processAttrObject(this);
}

bool
AttrObject::matchObjectAttributes(const StringMultiMap& attrVals,
                                  const GeoObject* obj,
                                  const StringSet& attrSubSet)
{
    for(const auto& attrId : attrSubSet) {
        auto itVal = attrVals.find(attrId);
        if (itVal == attrVals.end()) {
            if (!obj->attributes().value(attrId).empty()) {
                return false;
            }
        } else {
            if (itVal->second != obj->attributes().value(attrId)) {
                return false;
            }
        }
    }
    return true;
}

ObjectPtr
AttrObject::createUniqueObject(
    ObjectsCache& cache,
    const std::string& categoryId,
    const StringMultiMap& attrVals,
    const StringSet& attrsSubSet)
{
    GeoObjectCollection existing = cache.find(
        [&] (const GeoObject* obj) -> bool
        {
            return obj->categoryId() == categoryId &&
                matchObjectAttributes(attrVals, obj, attrsSubSet);
        });
    if (!existing.empty()) {
        REQUIRE(existing.size() == 1, "More than one matching attribute object found");
        DEBUG() << " ATR Found exisitng object match in collection: " << existing.front()->id();
        return existing.front();
    }

    bool allValuesEmpty = true;
    for (const auto& attr : attrsSubSet) {
        auto valIt = attrVals.find(attr);
        if(valIt != attrVals.end()){
            if (!valIt->second.empty()) {
                allValuesEmpty = false;
                break;
            }
        }
    }
    WIKI_REQUIRE(
        !allValuesEmpty,
        ERR_MANDATORY_ATTRIBUTE_MISSING,
        "Row values are not set.");

    return createObject(cache, categoryId, attrVals);
}

ObjectPtr
AttrObject::createObject(ObjectsCache& cache,
    const std::string& categoryId, const StringMultiMap& attrVals)
{
    ObjectPtr obj = GeoObjectFactory(cache).createNewObject(
        ObjectsClassInfos::attributesClassInfo,
        categoryId);
    AttrObject* attrObj = as<AttrObject>(obj);
    std::stringstream debugStream;
    for(auto aIt = attrVals.begin(); aIt != attrVals.end(); aIt++){
        if(attrObj->attributes().isDefined(aIt->first)){
            if(cfg()->editor()->attribute(aIt->first)->multiValue()){
                attrObj->attributes().addValue(aIt->first, aIt->second);
            } else {
                attrObj->attributes().setValue(aIt->first, aIt->second);
            }
            debugStream << " " << aIt->first << " = " << aIt->second;
        }
    }
    DEBUG() << " ATR created AttrObject " << attrObj->id() << " c: " << categoryId
        << " attributes " << debugStream.str();
    attrObj->setAllModified();
    return obj;
}

} // namespace wiki
} // namespace maps
