#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>

namespace maps {
namespace wiki {

class ObjectsCache;

/**
* AttrObject is a kind of object
* which only purpose is to keep table attribute row values
* and must not contain geometry
* AttrObjects should be unique in its current revision
* by set of the attribute values (domain_attrs)
*/

class AttrObject : public GeoObject
{
public:
    template <class T> friend class Constructor;

    AttrObject(const TRevisionId& id, ObjectsCache& cache);

    //From GeoObject
    virtual void applyVisitor(ObjectVisitor& visitor) const;
    virtual void applyProcessor(ObjectProcessor& processor);

    /**
    * Search cache and database for same AttrObject by attributes
    *   and create new if it's not found.
    * Complex objects not considered as equal for now
    * TODO: think about complex attribute objects uniq existance
    */
    static ObjectPtr createUniqueObject(ObjectsCache& cache,
        const std::string& categoryId,
        const StringMultiMap& attrVals,
        const StringSet& attrsSubSet);

    static ObjectPtr createObject(ObjectsCache& cache,
        const std::string& categoryId,
        const StringMultiMap& attrVals);

    static bool matchObjectAttributes(const StringMultiMap& attrVals, const GeoObject* obj, const StringSet& subSet);

    virtual const std::string& tablename() const
    { return ObjectsClassInfos::attributesClassInfo.tableName; }

    virtual ObjectPtr clone() const
    {
        return ObjectPtr(new AttrObject(*this));
    }

protected:
    //From GeoObject
    virtual void generalize(Transaction& work);
};

} // namespace wiki
} // namespace maps
