#pragma once
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <string>

namespace maps::wiki {

const std::string NM_TYPE_SUFFIX = ":name_type";
const std::string NM_NAME_SUFFIX = ":name";
const std::string NM_IS_LOCAL_SUFFIX = ":is_local";
const std::string NM_LANG_SUFFIX = ":lang";

bool isNamedCategory(const std::string& categoryId);

//Category which has own geometry
bool isSimpleGeomCategory(const Category& category);
bool isSimpleGeomCategory(const std::string& categoryId);

//Contour (also known as face) category
bool isContourCategory(const Category& category);
bool isContourCategory(const std::string& categoryId);
bool isContourElementCategory(const std::string& categoryId);
bool isContourJunctionCategory(const std::string& categoryId);
bool isContourObjectCategory(const std::string& categoryId);

//Category which geometry represented by its direct slaves (linear elements)
bool isDirectGeomMasterCategory(const Category& category);

//Category which geometry represented by its indirect slaves (contours -> linear elements)
bool isIndirectGeomMasterCategory(const Category& category);
bool isIndirectGeomMasterCategory(const std::string& categoryId);

std::string nameAttrId(const std::string& categoryId);

std::string findAttrColumnNameBySuffix(const std::string& tableAttr, const std::string& columnSuffix);

bool isOutdoorPoi(const std::string& categoryId);
bool isIndoorPoi(const std::string& categoryId);
bool isPoi(const std::string& categoryId);

bool isTransportRoute(const std::string& categoryId);
bool isTransportThread(const std::string& categoryId);
bool isTransportStation(const std::string& categoryId);
bool isThreadElementRole(const std::string& categoryId, const std::string& roleId);

const std::string& stationCategory(const std::string& threadCategory);
const std::string& routeCategory(const std::string& threadCategory);

bool isLinearElement(const std::string& categoryId);
bool isJunction(const std::string& categoryId);
bool needCheckRelationsPermissions(const std::string& categoryId);

std::string bestViewTable(const StringSet& categories);

} // namespace maps::wiki
