#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>
#include <maps/wikimap/mapspro/services/editor/src/views/fwd.h>

namespace maps {
namespace wiki {

/**
* ComplexObject is a kind of object
* which aglomerates another objects in some logic
* and does not contain geometry
*/

class ComplexObject : public GeoObject
{
public:
    using ViewType = views::ComplexViewObject;

    template <class T> friend class Constructor;

    ComplexObject(const TRevisionId& id, ObjectsCache& cache);

    //From GeoObject
    virtual void applyVisitor(ObjectVisitor& visitor) const;
    virtual void applyProcessor(ObjectProcessor& processor);

    virtual const std::string& tablename() const
    { return ObjectsClassInfos::complexClassInfo.tableName; }

    virtual ObjectPtr clone() const
    {
        return ObjectPtr(new ComplexObject(*this));
    }

protected:
    //From GeoObject
    virtual void generalize(Transaction& work);

};

} // namespace wiki
} // namespace maps
