#include "helpers.h"
#include "category_traits.h"
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

namespace maps::wiki {
namespace {

StringSet
langs(TOid objectId, ObjectsCache& cache, bool localOnly)
{
    auto object = cache.getExisting(objectId);
    auto nmObjects = nmAttrObjects(object, cache);
    const auto& objNmAttrId = nameAttrId(object->categoryId());
    const auto& nmIsLocalAttr = findAttrColumnNameBySuffix(objNmAttrId, NM_IS_LOCAL_SUFFIX);
    const auto& nmLangAttr = findAttrColumnNameBySuffix(objNmAttrId, NM_LANG_SUFFIX);
    StringSet resultLangs;
    for (const auto& nmObject : nmObjects) {
        if (!localOnly || !nmObject->attributes().value(nmIsLocalAttr).empty()) {
            resultLangs.insert(nmObject->attributes().value(nmLangAttr));
        }
    }
    return resultLangs;
}
}//namespace

StringSet
langs(TOid objectId, ObjectsCache& cache)
{
    return langs(objectId, cache, false);
}

std::vector<ObjectPtr>
nmAttrObjects(const ObjectPtr& namedObject, ObjectsCache& cache)
{
    static const StringSet nmRoles{ NAME_TYPES_PRIORITY.begin(), NAME_TYPES_PRIORITY.end() };

    ASSERT(isNamedCategory(namedObject->categoryId()));
    std::vector<ObjectPtr> nmObjects;
    for (const auto& nmSlave : namedObject->slaveRelations().range(nmRoles)) {
        nmObjects.push_back(cache.getExisting(nmSlave.id()));
    }
    return nmObjects;
}

StringSet
localLangs(TOid objectId, ObjectsCache& cache)
{
    return langs(objectId, cache, true);
}

bool isPermalinkReset(const GeoObject* object)
{
    return object->original() &&
        object->attributes().value(ATTR_POI_BUSINESS_ID).empty() &&
        !object->original()->attributes().value(ATTR_POI_BUSINESS_ID).empty();
}
} // namespace maps::wiki
