#include "junction.h"
#include "linear_element.h"

#include <maps/wikimap/mapspro/services/editor/src/collection.h>
#include <maps/wikimap/mapspro/services/editor/src/exception.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/objectvisitor.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <yandex/maps/wiki/configs/editor/topology_groups.h>

#include <maps/libs/log8/include/log8.h>

#include <boost/format.hpp>
#include <boost/current_function.hpp>

namespace maps {
namespace wiki {

Junction::Junction(const TRevisionId& id, ObjectsCache& cache)
    : GeoObject(id, cache)
{}

RelationInfos::Range
Junction::topologicalRelations() const
{
    auto topoGroup = cfg()->editor()->topologyGroups().findGroup(categoryId());
    REQUIRE(topoGroup,
        "Topology group not set for junction, id " << id() <<
        ", category " << categoryId());

    return masterRelations().range(
        StringSet{topoGroup->startJunctionRole(), topoGroup->endJunctionRole()});
}

size_t
Junction::valency() const
{
    return topologicalRelations().size();
}

void
Junction::applyVisitor(ObjectVisitor& visitor) const
{
    visitor.visitJunction(this);
}

void
Junction::applyProcessor(ObjectProcessor& processor)
{
    processor.processJunction(this);
}

} // namespace wiki
} // namespace maps
