#pragma once

#include "object.h"
#include <maps/wikimap/mapspro/services/editor/src/views/fwd.h>
#include <maps/wikimap/mapspro/services/editor/src/geom.h>
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/relation_infos.h>

namespace maps {
namespace wiki {

class Junction : public GeoObject
{
public:
    using ViewType = views::PointViewObject;

    template <class T> friend class Constructor;

    Junction(const TRevisionId& id, ObjectsCache& cache);

    RelationInfos::Range topologicalRelations() const;
    size_t valency() const;

    //From GeoObject
    virtual void applyVisitor(ObjectVisitor& visitor) const;
    virtual void applyProcessor(ObjectProcessor& processor);
    virtual const std::string& tablename() const
    { return ObjectsClassInfos::junctionClassInfo.tableName; }
    virtual double geometryCompareTolerance() const { return STRONG_CALCULATION_TOLERANCE; }
protected:
    virtual ObjectPtr clone() const { return ObjectPtr(new Junction(*this)); }

};

} // namespace wiki
} // namespace maps
