#pragma once

#include "complex_object.h"
#include <maps/wikimap/mapspro/services/editor/src/objectvisitor.h>

namespace maps {
namespace wiki {

class Model3dObject : public ComplexObject
{
public:
    Model3dObject(const TRevisionId& id, ObjectsCache& cache);

    virtual const std::string& tablename() const
    {
        return ObjectsClassInfos::model3dClassInfo.tableName;
    }

    virtual ObjectPtr clone() const
    {
        return ObjectPtr(new Model3dObject(*this));
    }

    virtual bool syncView() const /* override */;

protected:
    //From PointObject
    virtual void applyProcessor(ObjectProcessor& processor);
};

} // namespace wiki
} // namespace maps
