#include <maps/wikimap/mapspro/services/editor/src/objects/point_object.h>
#include <maps/wikimap/mapspro/services/editor/src/exception.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/categories.h>
#include <maps/wikimap/mapspro/services/editor/src/objectvisitor.h>

namespace maps {
namespace wiki {

PointObject::PointObject(const TRevisionId& id, ObjectsCache& cache)
    : GeoObject(id, cache)
{}

void
PointObject::applyVisitor(ObjectVisitor& visitor) const
{
    visitor.visitPointObject(this);
}

void
PointObject::applyProcessor(ObjectProcessor& processor)
{
    processor.processPointObject(this);
}

} // namespace wiki
} // namespace maps
