#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>
#include <maps/wikimap/mapspro/services/editor/src/views/fwd.h>

namespace maps {
namespace wiki {

class PointObject : public GeoObject
{
public:
    using ViewType = views::PointViewObject;

    PointObject(const TRevisionId& id, ObjectsCache& cache);

    virtual const std::string& tablename() const
    { return ObjectsClassInfos::pointClassInfo.tableName; }

    virtual ObjectPtr clone() const
    {
        return ObjectPtr(new PointObject(*this));
    }

protected:
    //From GeoObject
    virtual void applyVisitor(ObjectVisitor& visitor) const;
    virtual void applyProcessor(ObjectProcessor& processor);
};

} // namespace wiki
} // namespace maps
