#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>
#include <maps/wikimap/mapspro/services/editor/src/magic_strings.h>
#include <maps/wikimap/mapspro/services/editor/src/views/fwd.h>

namespace maps {
namespace wiki {

/**
* RelationObject is a kind of object
* which aglomerates another objects in some logic
* and does not contain geometry
*/

class RelationObject : public GeoObject
{
public:
    using ViewType = views::RelationViewObject;

    template <class T > friend class Constructor;

    //From GeoObject
    void applyVisitor(ObjectVisitor& visitor) const override;
    void applyProcessor(ObjectProcessor& processor) override;

    const std::string& tablename() const override
    {return ObjectsClassInfos::relationClassInfo.tableName;};

    void init(const revision::ObjectRevision& objectRev) override;

    bool syncView() const override;

    const std::string& role() const { return attributes().value(ATTR_REL_ROLE); }
    const std::string& masterCategoryId() const { return attributes().value(ATTR_REL_MASTER); }
    const std::string& slaveCategoryId() const { return attributes().value(ATTR_REL_SLAVE); }

    TOid masterId() const { return masterId_; }
    TOid slaveId() const  { return slaveId_;  }

    size_t seqNum() const;
    void setSeqNum(size_t seqNum);

    void setRelation(TOid masterId,
        const std::string& masterCat,
        TOid slaveId,
        const std::string& slaveCat,
        const std::string& roleId,
        size_t seqNum);

    ObjectPtr clone() const override
    {
        return ObjectPtr(new RelationObject(*this));
    }

    void calcModified() override;

    bool isModified() const override;
    bool isModifiedRelation() const;

    RelationObject(const TRevisionId& id, ObjectsCache& cache);

protected:
    //From GeoObject
    void generalize(Transaction& work) override;

    TOid masterId_;
    TOid slaveId_;
};

} // namespace wiki
} // namespace maps
