#pragma once

#include "objects/forward.h"

namespace maps {
namespace wiki {

class ObjectVisitor
{
public:
    virtual ~ObjectVisitor() {}
    virtual void visitGeoObject(const GeoObject* obj) = 0;
    virtual void visitArealObject(const ArealObject* obj) = 0;
    virtual void visitJunction(const Junction* obj) = 0;
    virtual void visitLinearElement(const LinearElement* obj) = 0;
    virtual void visitLineObject(const LineObject* obj) = 0;
    virtual void visitPointObject(const PointObject* obj) = 0;
    virtual void visitComplexObject(const ComplexObject* obj) = 0;
    virtual void visitAttrObject(const AttrObject* obj) = 0;
    virtual void visitRelationObject(const RelationObject* obj) = 0;
};

class ObjectProcessor
{
public:
    virtual ~ObjectProcessor() {}
    virtual void processGeoObject(GeoObject* obj) = 0;
    virtual void processArealObject(ArealObject* obj) = 0;
    virtual void processJunction(Junction* obj) = 0;
    virtual void processLinearElement(LinearElement* obj) = 0;
    virtual void processLineObject(LineObject* obj) = 0;
    virtual void processPointObject(PointObject* obj) = 0;
    virtual void processComplexObject(ComplexObject* obj) = 0;
    virtual void processAttrObject(AttrObject* obj) = 0;
    virtual void processRelationObject(RelationObject* obj) = 0;
    virtual void processModel3dObject(Model3dObject* obj) = 0;
};


}//wiki
}//maps
