#include "category_specific.h"
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/social/subscription_console.h>

namespace maps {
namespace wiki {

Observer::ContextDataPtr
CategorySpecificObserver::beforeCommit(
    ObjectsCache& cache,
    const GeoObjectCollection& modifiedObjects,
    UserContext& /*userContext*/,
    const CommitContext& /*commitContext*/) const
{
    auto filter = [](const GeoObject* object) {
        return object->categoryId() == CATEGORY_FEED_REGION;
    };
    for (const auto& object : modifiedObjects.find(filter)) {
        object->setScreenLabel(
                object->attributes().value(ATTR_FEED_REGION_NAME));

        auto uid = cache.savedCommit().createdBy();
        auto& txnSocial = cache.branchContext().txnSocial();
        auto console = social::Gateway(txnSocial).subscriptionConsole(uid);
        if (object->isCreated()) {
            console.subscribe(object->id());
        } else if (object->isDeleted()) {
            console.dropSubscription(object->id());
        }
    }
    return Observer::ContextDataPtr();
}

} // namespace wiki
} // namespace maps
