#include "diffalert_runner_proxy.h"
#include "diffalert_runner.h"
#include <yandex/maps/wiki/common/commit_properties.h>

namespace maps::wiki {

DiffAlertRunnerProxy::DiffAlertRunnerProxy(
        const DiffAlertRunner& runner,
        ObjectsCache& cache,
        const GeoObjectCollection& modifiedObjects,
        std::string commitAction)
    : runner_(runner)
    , cache_(cache)
    , modifiedObjects_(modifiedObjects)
    , commitAction_(std::move(commitAction))
{}

const std::vector<diffalert::Message>&
DiffAlertRunnerProxy::messages()
{
    if (!messages_) {
        if (common::COMMIT_GROUP_ACTIONS.count(commitAction_)) {
            messages_ = std::make_unique<std::vector<diffalert::Message>>();
        } else {
            messages_ = std::make_unique<std::vector<diffalert::Message>>(runner_.run(cache_, modifiedObjects_));
        }
    }
    return *messages_;
}

} // namespace maps::wiki
