#pragma once

#include <yandex/maps/wiki/diffalert/message.h>

#include <memory>
#include <string>
#include <vector>

namespace maps::wiki {

class DiffAlertRunner;
class ObjectsCache;
class GeoObjectCollection;

class DiffAlertRunnerProxy
{
public:
    DiffAlertRunnerProxy(
            const DiffAlertRunner& runner,
            ObjectsCache& cache,
            const GeoObjectCollection& modifiedObjects,
            std::string commitAction);

    const std::vector<diffalert::Message>& messages();

protected:
    const DiffAlertRunner& runner_;
    ObjectsCache& cache_;
    const GeoObjectCollection& modifiedObjects_;
    std::string commitAction_;

    std::unique_ptr<std::vector<diffalert::Message>> messages_;
};

} // namespace maps::wiki
