#pragma once

#include <maps/wikimap/mapspro/services/editor/src/collection.h>
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <vector>

namespace maps::wiki {

class EnvelopeInfo
{
public:
    EnvelopeInfo(const GeoObjectCollection& collection, ObjectsCache& cache);

    const std::vector<ObjectPtr>& geomDiffObjects() const { return objects_; }
    const geos::geom::Envelope& envelope() const { return envelope_; }

private:
    std::vector<ObjectPtr> objects_;
    geos::geom::Envelope envelope_;
};

} // namespace maps::wiki
