#pragma once

#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include "maps/wikimap/mapspro/services/editor/src/context.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"
#include "maps/wikimap/mapspro/services/editor/src/user_context.h"

namespace maps::wiki {

class ObjectsCache;

const ObjectPredicate allObjectsPredicate = [] (const GeoObject*) -> bool { return true; };

/**
 * @brief Provides additional information for Observers
 */
struct CommitContext
{
    boost::optional<TId> feedbackTaskId;
    std::unordered_map<TOid, DiffAlertsData> predefinedDiffAlerts = {};
};

/**
 * @brief Observer interface, registered in servant
 */
class Observer
{
public:
    class ContextData
    {
    public:
        virtual ~ContextData() = default;
    };

    typedef std::shared_ptr<ContextData> ContextDataPtr;

    virtual ~Observer() = default;

    virtual ContextDataPtr beforeCommit(
        ObjectsCache& cache,
        const GeoObjectCollection& modifiedObjects,
        UserContext& userContext,
        const CommitContext& commitContext) const = 0;

    virtual void afterCommit(
        TBranchId branchId,
        ContextData& data) const = 0;

    // return value boost::none - process afterCommit() in synchronous mode
    virtual boost::optional<AfterCommitPoolType> afterCommitPoolType() const
    { return AfterCommitPoolType::View; }
};

typedef std::shared_ptr<Observer> ObserverPtr;

class ObserverCollection
{
public:
    void add(ObserverPtr pObserver);

    Token doCommit(
        ObjectsCache& cache,
        UserContext& userContext,
        const CommitContext& commitContext = CommitContext()) const;

    std::list<Observer::ContextDataPtr> beforeCommit(ObjectsCache& cache,
        UserContext& userContext,
        const CommitContext& commitContext = CommitContext()) const;
    void afterCommit(std::list<Observer::ContextDataPtr>& dataPtrList, TBranchId branchId) const;
private:
    typedef std::list<ObserverPtr> Observers;
    Observers observers_;
};

} // namespace maps::wiki
