#pragma once

#include "observer.h"

namespace maps {
namespace wiki {

class ObjectsCache;

class RendererObserver : public Observer
{
public:
    RendererObserver();

    // from Observer
    Observer::ContextDataPtr beforeCommit(
        ObjectsCache& cache,
        const GeoObjectCollection& modifiedObjects,
        UserContext& userContext,
        const CommitContext& commitContext) const override;
    void afterCommit(
        TBranchId branchId,
        Observer::ContextData& data) const override;

    static void deleteLabels(const TOIds&, Transaction& workLabels);

    static bool placeLabels(
        const TOIds& ids,
        Transaction& workView,
        Transaction& workLabels,
        TBranchId branchId);

    static void placeAllLabels(
        Transaction& workView,
        Transaction& workLabels,
        TBranchId branchId);

private:
    class RendererContextData;

    typedef std::unique_ptr<RendererContextData> ContextPtr;

    TOIds computeDeletedLabelIds(ObjectsCache& cache, ObjectPredicate filter) const;
    TOIds computePlacedLabelIds(ObjectsCache& cache, ObjectPredicate filter) const;

    bool isNeedLabel(const GeoObject* object) const;

private:
    const StringSet labeledCategories_;
};

} // namespace maps
} // namespace wiki
