#include "revision_meta_queue.h"

#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>
#include <maps/wikimap/mapspro/services/editor/src/revision_meta/update_queue.h>

namespace maps {
namespace wiki {

Observer::ContextDataPtr
RevisionMetaQueue::beforeCommit(
    ObjectsCache& cache,
    const GeoObjectCollection&,
    UserContext& /*userContext*/,
    const CommitContext& /*commitContext*/) const
{
    revision_meta::CommitsQueue commitsQueue{
        cache.workCore(),
        cache.branchContext().branch.id()
    };
    commitsQueue.push(cache.savedCommit().id());

    return {};
}


} // namespace wiki
} // namespace maps
