#pragma once

#include "observer.h"
#include "diffalert_runner.h"

namespace maps {
namespace wiki {

class ObjectsCache;

class SocialObserver : public Observer
{
public:
    Observer::ContextDataPtr beforeCommit(
        ObjectsCache& cache,
        const GeoObjectCollection& modifiedObjects,
        UserContext& userContext,
        const CommitContext& commitContext) const override;
    void afterCommit(
        TBranchId branchId,
        Observer::ContextData& data) const override;

    boost::optional<AfterCommitPoolType> afterCommitPoolType() const override
    { return boost::none; }

private:
    struct SocialContextData;

    DiffAlertRunner diffAlertRunner_;
};

} // namespace wiki
} // namespace maps
