#pragma once

#include "observer.h"
#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include <maps/wikimap/mapspro/libs/poi_feed/include/feed_object_data.h>
#include <maps/libs/chrono/include/time_point.h>

namespace maps::wiki {

class ObjectsCache;

class SpravPoiObserver : public Observer
{
public:
    Observer::ContextDataPtr beforeCommit(
        ObjectsCache& cache,
        const GeoObjectCollection& modifiedObjects,
        UserContext& userContext,
        const CommitContext& commitContext) const override;

    void afterCommit(
        TBranchId branchId,
        Observer::ContextData& data) const override;

    boost::optional<AfterCommitPoolType> afterCommitPoolType() const override
    { return AfterCommitPoolType::Core; }
};

std::optional<poi_feed::FeedObjectData> createSpravPoiSignal(
    const GeoObject* object,
    const maps::chrono::TimePoint& timePoint);

} // namespace maps::wiki
