#pragma once

#include <maps/wikimap/mapspro/services/editor/src/acl_role_info.h>
#include <maps/wikimap/mapspro/services/editor/src/collection.h>
#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/services/editor/src/moderation.h>

#include <maps/wikimap/mapspro/services/editor/src/social_utils.h>

#include <maps/wikimap/mapspro/libs/acl/include/policy.h>
#include <maps/wikimap/mapspro/libs/acl/include/role.h>
#include <yandex/maps/wiki/common/moderation.h>

namespace maps::wiki {
class DiffAlertRunnerProxy;
class EnvelopeInfo;

class TrustLevelCalculator
{
public:
    TrustLevelCalculator(
        const BranchContext& branchCtx,
        const acl::User& user,
        const TOIds& aoiIds,
        const EnvelopeInfo& envelopeInfo,
        const revision::Commit& commit,
        DiffAlertRunnerProxy& diffAlertRunner);

    moderation::TrustLevel calculate(const GeoObjectCollection& collection);

private:
    moderation::TrustLevel calculateInternal(const ObjectPtr& primaryObj);
    const moderation::AclRoleInfo& getRoleInfo(const acl::Policy& policy);
    const BranchContext& branchCtx_;
    const acl::User& user_;
    const TOIds& aoiIds_;
    const EnvelopeInfo& envelopeInfo_;
    const revision::Commit& commit_;
    DiffAlertRunnerProxy& diffAlertRunner_;
    std::optional<std::vector<acl::Policy>> userPolicies_;
    std::unordered_map<std::string, moderation::AclRoleInfo> roleInfos_;
};

} // namespace maps::wiki
