#pragma once

#include "observer.h"
#include <maps/wikimap/mapspro/services/editor/src/common.h>

namespace maps {
namespace wiki {

class GeoObject;
class ObjectsCache;

class ViewSyncronizer : public Observer
{
public:
    ContextDataPtr beforeCommit(
        ObjectsCache& cache,
        const GeoObjectCollection& modifiedObjects,
        UserContext& userContext,
        const CommitContext& commitContext) const override;

    //TODO: move me to parent after explicit overrides will become available (4.8)
    virtual void afterCommit(
        TBranchId /* branchId */,
        Observer::ContextData& /* data */) const override {};

    void updateObjectsSuggests(
        ObjectsCache& cache,
        ObjectPredicate filter,
        bool checkSuggestExists) const;
};

} // namespace wiki
} // namespace maps
