#pragma once

#include "relation_infos.h"

#include <set>
#include <map>
#include <string>

namespace maps {
namespace wiki {

class GeoObject;
class ObjectsCache;

class RelationsProcessor
{
public:
    explicit RelationsProcessor(ObjectsCache& cache);

    void deleteRelations(RelationType relationType, GeoObject* object);
    void deleteRelations(RelationType relationType,
        GeoObject* object, const StringSet& roleIds);

    void deleteAllRelations(GeoObject* object);

    bool canBeReplacedWithMerged(RelationType relationType,
        const GeoObject* deleted, const GeoObject* replacement);
    bool canBeReplacedWithMerged(RelationType relationType,
        const GeoObject* deleted, const GeoObject* replacement,
        const StringSet& roleIds);
    void replaceWithMerged(RelationType relationType,
        GeoObject* deleted, GeoObject* replacement);
    void replaceWithMerged(RelationType relationType,
        GeoObject* deleted, GeoObject* replacement,
        const StringSet& roleIds);

    void replaceWithParts(RelationType relationType,
        GeoObject* source, const std::vector<GeoObject*>& parts);

private:
    void replace(const std::string& roleId,
            GeoObject* masterWhere, GeoObject* slaveWhat,
            const std::vector<GeoObject*>& partsWith);

    void deleteFromRelations(
        const GeoObject* deleted,
        const MixedRolesInfosContainer& relations);
    void replaceRelationsWithMerged(
        const GeoObject* deleted, const GeoObject* replacement,
        const MixedRolesInfosContainer& relations);

    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
