#pragma once

#include "common.h"

#undef BOOST_HAS_RVALUE_REFS
#include <yandex/maps/tilerenderer4/IOnlineRenderer.h>

namespace maps {
namespace wiki {

class RendererLayersTraverse: public tilerenderer4::ILayersTraverse
{
public:
    typedef unsigned int LayerId;
    struct ProjectParams
    {
        StringSet mapTypes;
        StringSet projects;
        StringSet aclGroups;
        bool match(const ProjectParams& requested) const;
    };

    struct LayersGroup
    {
        std::string id;
        StringSet complexCategories;
    };

    struct Representation
    {
        LayerId id;
        std::string name;
        std::string label;
        ProjectParams projectParams;
    };

    struct TextLayer
    {
        LayerId id;
        ProjectParams projectParams;
    };

    /// base or selection

    class Layer
    {
    public:
        typedef std::list<Representation> Representations;

        Layer(const std::string& type, const tilerenderer4::LayerInfo& layer);

        LayerId id() const { return id_; }
        const std::string& type() const { return type_; }
        const std::string& groupId() const { return groupId_; }
        const std::string& name() const { return name_; }
        const boost::optional<std::string>& label() const { return label_; }

        const StringVec& categoryIds() const { return categoryIds_; }

        const boost::optional<TextLayer>& textLayer() const { return textLayer_; }
        void setTextLayer(TextLayer textLayer) { textLayer_ = textLayer; }

        const Representations& representations() const { return representations_; }
        void appendRepresentation(Representation&& representation)
        {
            representations_.push_back(std::move(representation));
        }

        const ProjectParams& projectParams() const { return projectParams_; }

        bool isFilterLayer() const;

    private:
        LayerId id_;
        std::string type_;
        std::string groupId_;
        std::string name_;
        boost::optional<std::string> label_;

        StringVec categoryIds_;

        boost::optional<TextLayer> textLayer_;
        Representations representations_;
        ProjectParams projectParams_;
    };

    typedef  std::map<std::string, std::list<const Layer*>> LayersByGroup;

    //! From ILayersTraverse
    bool onEnterGroupLayer(const tilerenderer4::LayerInfo& layer);
    bool onVisitLayer(const tilerenderer4::LayerInfo& layer);
    void onLeaveGroupLayer(const tilerenderer4::LayerInfo& layer);
    bool isDone();

    const LayersByGroup& layersByGroup() const { return layersByGroup_; }
    const StringSet& labeledCategories() const
    {
        return labeledCategories_;
    }

    std::map<std::string, LayersGroup>& layersGroups() { return layersGroups_; }
    const LayersGroup& layersGroup(const std::string& grpId) const { return layersGroups_.find(grpId)->second; }

private:
    Layer& currentLayer();

    std::list<Layer> layers_;
    LayersByGroup layersByGroup_;
    std::map<std::string, LayersGroup> layersGroups_;

    StringSet labeledCategories_;
};

std::string layersGroupLabel(const std::string& grpId);

} // namespace wiki
} // namespace maps
