#include "bbox_context.h"

#include <maps/wikimap/mapspro/services/editor/src/sync/db_helpers.h>

namespace maps {
namespace wiki {

BBoxContext::BBoxContext(
        ExecutionStatePtr executionState,
        TBranchId branchId,
        TCommitId startCommitId,
        TCommitId endCommitId,
        TCommitId headCommitId,
        TCommitIds customCommitIds)
    : executionState_(std::move(executionState))
    , branchId_(branchId)
    , startCommitId_(startCommitId)
    , endCommitId_(endCommitId)
    , headCommitId_(headCommitId)
    , customCommitIds_(std::move(customCommitIds))
{
    ASSERT(startCommitId_ <= endCommitId_);

    if (!customCommitIds_.empty()) {
        ASSERT(*customCommitIds_.begin() >= startCommitId_);
        ASSERT(*customCommitIds_.rbegin() <= endCommitId_);
    }
}

bool BBoxContext::checkOk(Transaction& workCore) const
{
    return executionState_->checkOk(workCore);
}

BranchContext BBoxContext::getReadContext() const
{
    BranchContextFacade bcFacade(branchId_);
    if (cfg()->tryLongReadAccess()) {
        return bcFacade.acquireLongReadCoreOnly(headCommitId_);
    }
    return bcFacade.acquireWrite();
}

} // namespace wiki
} // namespace maps
