#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/execution_state.h>
#include <maps/wikimap/mapspro/services/editor/src/revision_meta/common.h>

namespace maps {
namespace wiki {

class BBoxContext
{
public:
    BBoxContext(
        ExecutionStatePtr executionState,
        TBranchId branchId,
        TCommitId startCommitId,
        TCommitId endCommitId,
        TCommitId headCommitId,
        TCommitIds customCommitIds);

    bool checkOk(Transaction& workCore) const;

    TBranchId branchId() const { return branchId_; }
    TCommitId startCommitId() const { return startCommitId_; }
    TCommitId endCommitId() const { return endCommitId_; }
    const TCommitIds& customCommitIds() const { return customCommitIds_; }

    BranchContext getReadContext() const;

private:
    ExecutionStatePtr executionState_;

    TBranchId branchId_;
    TCommitId startCommitId_;
    TCommitId endCommitId_;
    TCommitId headCommitId_;
    TCommitIds customCommitIds_;
};

} // namespace wiki
} // namespace maps
