#include "bbox_helpers.h"

#include <maps/wikimap/mapspro/services/editor/src/utils.h>

namespace maps::wiki {

size_t
DatabaseBBoxProvider::copy(
    Transaction& txn,
    TBranchId sourceBranchId,
    TBranchId targetBranchId)
{
    std::ostringstream query;
    query <<
        "INSERT INTO revision_meta.geometry"
        " SELECT object_id, commit_id, " << targetBranchId << " AS branch_id, "
                "the_geom, categories"
        " FROM revision_meta.geometry"
        " WHERE branch_id = " << sourceBranchId;

    return txn.exec(query.str()).affected_rows();
}

GeomComposer::GeomComposer()
{
    result_.init();
}

Geom GeomComposer::result() const
{
    if (empty_) {
        return Geom();
    }
    return Geom(createGeom(result_, SpatialRefSystem::Mercator));
}

} // namespace maps::wiki
