#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

namespace maps::wiki {

class DatabaseBBoxProvider
{
public:
    static size_t copy(
        Transaction& txn,
        TBranchId sourceBranchId,
        TBranchId targetBranchId);
};

class GeomComposer {
public:
    GeomComposer();

    void process(const Geom& geom)
    {
        if (geom.isNull()) {
            return;
        }
        auto env = geom.geosGeometryPtr()->getEnvelopeInternal();
        if (!env) {
            return;
        }
        empty_ = false;
        result_.expandToInclude(env);
    }

    Geom result() const;

private:
    geos::geom::Envelope result_;
    bool empty_{true};
};

} // namespace maps::wiki
